/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.util;

import java.io.ByteArrayInputStream;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.metawidget.util.CollectionUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlUtils {
    private static final DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY = DocumentBuilderFactory.newInstance();
    private static final Pattern PATTERN_AMP;
    private static final Pattern PATTERN_LT;
    private static final Pattern PATTERN_GT;
    private static final Pattern PATTERN_QUOT;

    public static Map<String, String> getAttributesAsMap(Node node) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        int n = namedNodeMap.getLength();
        if (n == 0) {
            Map map = Collections.EMPTY_MAP;
            return map;
        }
        HashMap<String, String> hashMap = CollectionUtils.newHashMap(n);
        for (int i = 0; i < n; ++i) {
            Node node2 = namedNodeMap.item(i);
            hashMap.put(node2.getNodeName(), node2.getNodeValue());
        }
        return hashMap;
    }

    public static void setMapAsAttributes(Element element, Map<String, String> map) {
        if (map == null) {
            return;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            element.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    public static Element getChildNamed(Element element, String[] stringArray) {
        if (element == null) {
            return null;
        }
        Element element2 = null;
        NodeList nodeList = element.getChildNodes();
        for (String string : stringArray) {
            block4: {
                int n = nodeList.getLength();
                for (int i = 0; i < n; ++i) {
                    Node node = nodeList.item(i);
                    if (!(node instanceof Element) || !string.equals((element2 = (Element)node).getLocalName())) {
                        continue;
                    }
                    break block4;
                }
                return null;
            }
            nodeList = element2.getChildNodes();
        }
        return element2;
    }

    public static Element getChildWithAttribute(Element element, String string) {
        if (element == null) {
            return null;
        }
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2;
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !(element2 = (Element)node).hasAttribute(string)) continue;
            return element2;
        }
        return null;
    }

    public static Element getChildWithAttributeValue(Element element, String string, String string2) {
        int n;
        NodeList nodeList;
        if (element == null) {
            return null;
        }
        try {
            nodeList = element.getChildNodes();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        try {
            n = nodeList.getLength();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
        for (int i = 0; i < n; ++i) {
            Node node;
            try {
                node = nodeList.item(i);
            }
            catch (NullPointerException nullPointerException) {
                continue;
            }
            if (!(node instanceof Element)) continue;
            Element element2 = (Element)node;
            try {
                if (!string2.equals(element2.getAttribute(string))) continue;
                return element2;
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Element getSiblingNamed(Element element, String string) {
        if (element == null) {
            return null;
        }
        Node node = element;
        do {
            if ((node = node.getNextSibling()) != null) continue;
            return null;
        } while (!(node instanceof Element) || !string.equals(node.getNodeName()));
        return (Element)node;
    }

    public static Element importElement(Document document, Element element) {
        try {
            return (Element)document.importNode(element, true);
        }
        catch (DOMException dOMException) {
            Element element2 = document.createElementNS(element.getNamespaceURI(), element.getNodeName());
            XmlUtils.setMapAsAttributes(element2, XmlUtils.getAttributesAsMap(element));
            NodeList nodeList = element2.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Element)) continue;
                element2.appendChild(XmlUtils.importElement(document, (Element)node));
            }
            return element2;
        }
    }

    public static String documentToString(Document document, boolean bl) {
        if (document == null) {
            return "";
        }
        return XmlUtils.nodeToString(document.getFirstChild(), bl ? 0 : -1);
    }

    public static Document documentFromString(String string) {
        if (string == null) {
            return null;
        }
        try {
            return XmlUtils.newDocumentBuilder().parse(new InputSource(new StringReader(string)));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static DocumentBuilder newDocumentBuilder() throws ParserConfigurationException {
        return DOCUMENT_BUILDER_FACTORY.newDocumentBuilder();
    }

    public static Element getElementAt(Element element, int n) {
        NodeList nodeList = element.getChildNodes();
        int n2 = 0;
        int n3 = nodeList.getLength();
        for (int i = 0; i < n3; ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            if (n2 == n) {
                return (Element)node;
            }
            ++n2;
        }
        return null;
    }

    public static void combineElements(Element element, Element element2, String string, String string2) {
        Object object;
        Object object2;
        NamedNodeMap namedNodeMap = element2.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            object2 = namedNodeMap.item(i);
            object = object2.getNodeName();
            String string3 = object2.getNodeValue();
            if (string3 == null || string3.length() == 0) {
                element.removeAttribute((String)object);
            }
            element.setAttribute((String)object, string3);
        }
        NodeList nodeList = element2.getChildNodes();
        NodeList nodeList2 = element.getChildNodes();
        object2 = CollectionUtils.newHashSet();
        object = null;
        int n2 = nodeList.getLength();
        block1: for (int i = 0; i < n2; ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element element3 = (Element)node;
            String string4 = element3.getAttribute(string);
            if (string4 == null || "".equals(string4)) {
                throw new RuntimeException(new StringBuffer().append("Child node #").append(i).append(" (").append(element3.getNodeName()).append(") has no @").append(string).toString());
            }
            if (!object2.add(string4)) {
                throw new RuntimeException(new StringBuffer().append("Element has more than one child with @").append(string).append(" '").append(string4).append("'").toString());
            }
            int n3 = nodeList2.getLength();
            for (int j = 0; j < n3; ++j) {
                String string5;
                Element element4;
                String string6;
                Node node2 = nodeList2.item(j);
                if (!(node2 instanceof Element) || !string4.equals(string6 = (element4 = (Element)node2).getAttribute(string))) continue;
                String string7 = element4.getNodeName();
                if (!string7.equals(string5 = element3.getNodeName())) {
                    throw new RuntimeException(new StringBuffer().append("Matching elements named '").append(string6).append("', but existing one is a '").append(string7).append("' whilst new one is a '").append(string5).append("'").toString());
                }
                object = j == n3 - 1 ? null : element4;
                XmlUtils.combineElements(element4, element3, string2, string2);
                continue block1;
            }
            if (object != null) {
                Element element5 = XmlUtils.importElement(element.getOwnerDocument(), element3);
                element.insertBefore(element5, object.getNextSibling());
                object = element5;
                continue;
            }
            element.appendChild(XmlUtils.importElement(element.getOwnerDocument(), element3));
        }
    }

    public static String attributesToString(Attributes attributes) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
            stringBuffer.append(attributes.getLocalName(i));
            stringBuffer.append("=\"");
            stringBuffer.append(attributes.getValue(i));
            stringBuffer.append("\"");
        }
        return stringBuffer.toString();
    }

    private static String nodeToString(Node node, int n) {
        Object object;
        if (!(node instanceof Element)) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("   ");
        }
        String string = XmlUtils.escapeForXml(node.getNodeName());
        stringBuffer.append("<");
        stringBuffer.append(string);
        String string2 = node.getNamespaceURI();
        Node node2 = node.getParentNode();
        if (!(string2 == null || node2 != null && string2.equals(node2.getNamespaceURI()))) {
            stringBuffer.append(" xmlns=\"");
            stringBuffer.append(string2);
            stringBuffer.append("\"");
        }
        Map<String, String> map = XmlUtils.getAttributesAsMap(node);
        if (n > -1 && (object = map.get("name")) != null) {
            stringBuffer.append(" name=\"");
            stringBuffer.append(XmlUtils.escapeForXml((String)object));
            stringBuffer.append("\"");
        }
        for (Map.Entry entry : map.entrySet()) {
            String string3 = (String)entry.getKey();
            if ("xmlns".equals(string3) || n > -1 && "name".equals(string3)) continue;
            stringBuffer.append(" ");
            stringBuffer.append(XmlUtils.escapeForXml(string3));
            stringBuffer.append("=\"");
            stringBuffer.append(XmlUtils.escapeForXml((String)entry.getValue()));
            stringBuffer.append("\"");
        }
        object = node.getChildNodes();
        int n2 = object.getLength();
        if (n2 == 0) {
            stringBuffer.append("/>");
        } else {
            int n3;
            stringBuffer.append(">");
            int n4 = n;
            if (n != -1) {
                stringBuffer.append("\n");
                ++n4;
            }
            for (n3 = 0; n3 < n2; ++n3) {
                stringBuffer.append(XmlUtils.nodeToString(object.item(n3), n4));
            }
            for (n3 = 0; n3 < n; ++n3) {
                stringBuffer.append("   ");
            }
            stringBuffer.append("</");
            stringBuffer.append(string);
            stringBuffer.append(">");
        }
        if (n > 0) {
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private static String escapeForXml(String string) {
        if (string == null) {
            return "";
        }
        String string2 = string;
        string2 = PATTERN_AMP.matcher(string2).replaceAll("&amp;");
        string2 = PATTERN_LT.matcher(string2).replaceAll("&lt;");
        string2 = PATTERN_GT.matcher(string2).replaceAll("&gt;");
        string2 = PATTERN_QUOT.matcher(string2).replaceAll("&quot;");
        return string2;
    }

    private XmlUtils() {
    }

    static {
        DOCUMENT_BUILDER_FACTORY.setNamespaceAware(true);
        DOCUMENT_BUILDER_FACTORY.setIgnoringComments(true);
        DOCUMENT_BUILDER_FACTORY.setIgnoringElementContentWhitespace(true);
        PATTERN_AMP = Pattern.compile("&", 16);
        PATTERN_LT = Pattern.compile("<", 16);
        PATTERN_GT = Pattern.compile(">", 16);
        PATTERN_QUOT = Pattern.compile("\"", 16);
    }

    public static class CachingContentHandler
    extends DefaultHandler {
        private ContentHandler mDelegate;
        private CachedCommand mLastCommand;
        private List<CachedCommand> mCache = CollectionUtils.newArrayList();
        private boolean mCachingPaused;

        public CachingContentHandler(ContentHandler contentHandler) {
            this.mDelegate = contentHandler;
        }

        public boolean isPaused() {
            return this.mCachingPaused;
        }

        public void pause(boolean bl) {
            if (this.isPaused()) {
                throw new RuntimeException("CachingContentHandler already paused");
            }
            this.mCachingPaused = true;
            if (!bl) {
                this.mCache.remove(this.mCache.size() - 1);
            }
        }

        public void unpause(boolean bl) {
            if (!this.isPaused()) {
                throw new RuntimeException("CachingContentHandler not paused");
            }
            this.mCachingPaused = false;
            if (bl) {
                this.mCache.add(this.mLastCommand);
            }
        }

        public void replay(ContentHandler contentHandler) throws SAXException {
            if (this.mCache.isEmpty()) {
                throw new SAXException("Nothing to replay. Not cached any SAX events");
            }
            Iterator<CachedCommand> iterator = this.mCache.iterator();
            while (iterator.hasNext()) {
                CachedCommand cachedCommand = iterator.next();
                cachedCommand.replay(contentHandler);
            }
        }

        public void startDocument() throws SAXException {
            this.mLastCommand = new StartDocumentCommand();
            if (!this.mCachingPaused) {
                if (!this.mCache.isEmpty()) {
                    throw new SAXException("Already cached SAX events. CachingContentHandler can only cache SAX events once");
                }
                this.mCache.add(this.mLastCommand);
            }
            this.mLastCommand.replay(this.mDelegate);
        }

        public void processingInstruction(String string, String string2) throws SAXException {
            this.mLastCommand = new ProcessingInstructionCommand(string, string2);
            if (!this.mCachingPaused) {
                this.mCache.add(this.mLastCommand);
            }
            this.mLastCommand.replay(this.mDelegate);
        }

        public void setDocumentLocator(Locator locator) {
            this.mDelegate.setDocumentLocator(locator);
        }

        public void skippedEntity(String string) throws SAXException {
            this.mLastCommand = new SkippedEntityCommand(string);
            if (!this.mCachingPaused) {
                this.mCache.add(this.mLastCommand);
            }
            this.mLastCommand.replay(this.mDelegate);
        }

        public void startPrefixMapping(String string, String string2) throws SAXException {
            this.mLastCommand = new StartPrefixMappingCommand(string, string2);
            if (!this.mCachingPaused) {
                this.mCache.add(this.mLastCommand);
            }
            this.mLastCommand.replay(this.mDelegate);
        }

        public void endPrefixMapping(String string) throws SAXException {
            this.mLastCommand = new EndPrefixMappingCommand(string);
            if (!this.mCachingPaused) {
                this.mCache.add(this.mLastCommand);
            }
            this.mLastCommand.replay(this.mDelegate);
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.mLastCommand = new StartElementCommand(string, string2, string3, attributes);
            if (!this.mCachingPaused) {
                this.mCache.add(this.mLastCommand);
            }
            this.mLastCommand.replay(this.mDelegate);
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this.mLastCommand = new CharactersCommand(cArray, n, n2);
            if (!this.mCachingPaused) {
                this.mCache.add(this.mLastCommand);
            }
            this.mLastCommand.replay(this.mDelegate);
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
            this.mLastCommand = new IgnorableWhitespaceCommand(cArray, n, n2);
            if (!this.mCachingPaused) {
                this.mCache.add(this.mLastCommand);
            }
            this.mLastCommand.replay(this.mDelegate);
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            this.mLastCommand = new EndElementCommand(string, string2, string3);
            if (!this.mCachingPaused) {
                this.mCache.add(this.mLastCommand);
            }
            this.mLastCommand.replay(this.mDelegate);
        }

        public void endDocument() throws SAXException {
            this.mLastCommand = new EndDocumentCommand();
            if (!this.mCachingPaused) {
                this.mCache.add(this.mLastCommand);
            }
            this.mLastCommand.replay(this.mDelegate);
            this.mDelegate = null;
        }

        private static class EndDocumentCommand
        implements CachedCommand {
            public void replay(ContentHandler contentHandler) throws SAXException {
                contentHandler.endDocument();
            }

            public String toString() {
                return "endDocument";
            }
        }

        private static class EndElementCommand
        implements CachedCommand {
            private String mUri;
            private String mLocalName;
            private String mQName;

            public EndElementCommand(String string, String string2, String string3) {
                this.mUri = string;
                this.mLocalName = string2;
                this.mQName = string3;
            }

            public void replay(ContentHandler contentHandler) throws SAXException {
                contentHandler.endElement(this.mUri, this.mLocalName, this.mQName);
            }

            public String toString() {
                return "endElement " + this.mUri + " " + this.mLocalName + " " + this.mQName;
            }
        }

        private static class IgnorableWhitespaceCommand
        implements CachedCommand {
            private char[] mCharacters;

            public IgnorableWhitespaceCommand(char[] cArray, int n, int n2) {
                this.mCharacters = new char[n2];
                System.arraycopy(cArray, n, this.mCharacters, 0, n2);
            }

            public void replay(ContentHandler contentHandler) throws SAXException {
                contentHandler.ignorableWhitespace(this.mCharacters, 0, this.mCharacters.length);
            }

            public String toString() {
                return "ignorableWhitespace " + String.valueOf(this.mCharacters);
            }
        }

        private static class CharactersCommand
        implements CachedCommand {
            private char[] mCharacters;

            public CharactersCommand(char[] cArray, int n, int n2) {
                this.mCharacters = new char[n2];
                System.arraycopy(cArray, n, this.mCharacters, 0, n2);
            }

            public void replay(ContentHandler contentHandler) throws SAXException {
                contentHandler.characters(this.mCharacters, 0, this.mCharacters.length);
            }

            public String toString() {
                return "characters " + String.valueOf(this.mCharacters);
            }
        }

        private static class StartElementCommand
        implements CachedCommand {
            private String mUri;
            private String mLocalName;
            private String mQName;
            private Attributes mAttributes;

            public StartElementCommand(String string, String string2, String string3, Attributes attributes) {
                this.mUri = string;
                this.mLocalName = string2;
                this.mQName = string3;
                this.mAttributes = new AttributesImpl(attributes);
            }

            public void replay(ContentHandler contentHandler) throws SAXException {
                contentHandler.startElement(this.mUri, this.mLocalName, this.mQName, this.mAttributes);
            }

            public String toString() {
                return "startElement " + this.mUri + " " + this.mLocalName + " " + this.mQName + XmlUtils.attributesToString(this.mAttributes);
            }
        }

        private static class EndPrefixMappingCommand
        implements CachedCommand {
            private String mPrefix;

            public EndPrefixMappingCommand(String string) {
                this.mPrefix = string;
            }

            public void replay(ContentHandler contentHandler) throws SAXException {
                contentHandler.endPrefixMapping(this.mPrefix);
            }

            public String toString() {
                return "endPrefixMapping " + this.mPrefix;
            }
        }

        private static class StartPrefixMappingCommand
        implements CachedCommand {
            private String mPrefix;
            private String mUri;

            public StartPrefixMappingCommand(String string, String string2) {
                this.mPrefix = string;
                this.mUri = string2;
            }

            public void replay(ContentHandler contentHandler) throws SAXException {
                contentHandler.startPrefixMapping(this.mPrefix, this.mUri);
            }

            public String toString() {
                return "startPrefixMapping " + this.mPrefix + " " + this.mUri;
            }
        }

        private static class SkippedEntityCommand
        implements CachedCommand {
            private String mName;

            public SkippedEntityCommand(String string) {
                this.mName = string;
            }

            public void replay(ContentHandler contentHandler) throws SAXException {
                contentHandler.skippedEntity(this.mName);
            }

            public String toString() {
                return "skippedEntity " + this.mName;
            }
        }

        private static class ProcessingInstructionCommand
        implements CachedCommand {
            private String mTarget;
            private String mData;

            public ProcessingInstructionCommand(String string, String string2) {
                this.mTarget = string;
                this.mData = string2;
            }

            public void replay(ContentHandler contentHandler) throws SAXException {
                contentHandler.processingInstruction(this.mTarget, this.mData);
            }

            public String toString() {
                return "processInstruction " + this.mTarget + " " + this.mData;
            }
        }

        private static class StartDocumentCommand
        implements CachedCommand {
            public void replay(ContentHandler contentHandler) throws SAXException {
                contentHandler.startDocument();
            }

            public String toString() {
                return "startDocument";
            }
        }

        private static interface CachedCommand {
            public void replay(ContentHandler var1) throws SAXException;
        }
    }

    public static class NopEntityResolver
    implements EntityResolver {
        private static final byte[] BYTES = "<?xml version='1.0' encoding='UTF-8'?>".getBytes();

        public InputSource resolveEntity(String string, String string2) {
            return new InputSource(new ByteArrayInputStream(BYTES));
        }
    }
}

