/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.widgetbuilder.composite;

import java.util.Map;
import org.metawidget.widgetbuilder.composite.CompositeWidgetBuilderConfig;
import org.metawidget.widgetbuilder.iface.WidgetBuilder;
import org.metawidget.widgetbuilder.iface.WidgetBuilderException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeWidgetBuilder<W, M extends W>
implements WidgetBuilder<W, M> {
    final WidgetBuilder<W, M>[] mWidgetBuilders;

    public CompositeWidgetBuilder(CompositeWidgetBuilderConfig<W, M> compositeWidgetBuilderConfig) {
        WidgetBuilder<W, M>[] widgetBuilderArray = compositeWidgetBuilderConfig.getWidgetBuilders();
        if (widgetBuilderArray == null || widgetBuilderArray.length < 2) {
            throw WidgetBuilderException.newException("CompositeWidgetBuilder needs at least two WidgetBuilders");
        }
        this.mWidgetBuilders = new WidgetBuilder[widgetBuilderArray.length];
        System.arraycopy(widgetBuilderArray, 0, this.mWidgetBuilders, 0, widgetBuilderArray.length);
    }

    @Override
    public W buildWidget(String string, Map<String, String> map, M m) {
        for (WidgetBuilder<W, M> widgetBuilder : this.mWidgetBuilders) {
            W w = widgetBuilder.buildWidget(string, map, m);
            if (w == null) continue;
            return w;
        }
        return null;
    }

    public WidgetBuilder<W, M>[] getWidgetBuilders() {
        WidgetBuilder[] widgetBuilderArray = new WidgetBuilder[this.mWidgetBuilders.length];
        System.arraycopy(this.mWidgetBuilders, 0, widgetBuilderArray, 0, this.mWidgetBuilders.length);
        return widgetBuilderArray;
    }
}

