/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.faces.component.html.widgetbuilder;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlOutputText;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import org.metawidget.util.CollectionUtils;
import org.metawidget.widgetbuilder.iface.WidgetBuilderException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlLookupOutputText
extends HtmlOutputText {
    public static final String COMPONENT_TYPE = "org.metawidget.HtmlLookupOutputText";
    private List<String> mValues;
    private List<String> mLabels;

    public void setLabels(List<String> values, List<String> labels) {
        this.mValues = values;
        this.mLabels = labels;
        if (this.mValues.size() != this.mLabels.size()) {
            throw WidgetBuilderException.newException((String)("There are " + this.mValues.size() + " possible values, but " + this.mLabels.size() + " possible labels"));
        }
    }

    public Object getValue() {
        Object value = super.getValue();
        if (value == null) {
            return null;
        }
        if (value instanceof Collection) {
            Collection values = (Collection)value;
            if (values.isEmpty()) {
                return null;
            }
            try {
                boolean gotConverter = false;
                Converter converter = null;
                AbstractCollection labels = value instanceof Set ? CollectionUtils.newHashSet() : CollectionUtils.newArrayList();
                for (Object itemValue : values) {
                    Object label = null;
                    if (itemValue != null) {
                        if (!gotConverter) {
                            converter = this.getFacesContext().getApplication().createConverter(itemValue.getClass());
                            gotConverter = true;
                        }
                        label = this.convertAndLookup(converter, itemValue);
                    }
                    labels.add(label);
                }
                return labels;
            }
            catch (Exception e) {
                throw WidgetBuilderException.newException((Throwable)e);
            }
        }
        Converter converter = this.getConverter();
        if (converter == null) {
            converter = this.getFacesContext().getApplication().createConverter(value.getClass());
        }
        return this.convertAndLookup(converter, value);
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.mValues, this.mLabels};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.mValues = (List)values[1];
        this.mLabels = (List)values[2];
    }

    private Object convertAndLookup(Converter converter, Object value) {
        String convertedValue = converter != null ? converter.getAsString(this.getFacesContext(), (UIComponent)this, value) : String.valueOf(value);
        int indexOf = this.mValues.indexOf(convertedValue);
        if (indexOf != -1) {
            return this.mLabels.get(indexOf);
        }
        return value;
    }
}

