/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.beanvalidation;

import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.metawidget.inspector.impl.BaseObjectInspector;
import org.metawidget.inspector.impl.BaseObjectInspectorConfig;
import org.metawidget.inspector.impl.propertystyle.Property;
import org.metawidget.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanValidationInspector
extends BaseObjectInspector {
    public BeanValidationInspector() {
        this(new BaseObjectInspectorConfig());
    }

    public BeanValidationInspector(BaseObjectInspectorConfig config) {
        super(config);
    }

    protected Map<String, String> inspectProperty(Property property) throws Exception {
        Pattern pattern;
        Size size;
        Max max;
        Min min;
        HashMap attributes = CollectionUtils.newHashMap();
        Digits digits = (Digits)property.getAnnotation(Digits.class);
        if (digits != null) {
            int fractionalDigits;
            int integerDigits = digits.integer();
            if (integerDigits > 0) {
                attributes.put("maximum-integer-digits", String.valueOf(integerDigits));
            }
            if ((fractionalDigits = digits.fraction()) > 0) {
                attributes.put("maximum-fractional-digits", String.valueOf(fractionalDigits));
            }
        }
        if (property.isAnnotationPresent(NotNull.class)) {
            attributes.put("required", "true");
        }
        if ((min = (Min)property.getAnnotation(Min.class)) != null) {
            attributes.put("minimum-value", String.valueOf(min.value()));
        }
        if ((max = (Max)property.getAnnotation(Max.class)) != null) {
            attributes.put("maximum-value", String.valueOf(max.value()));
        }
        if ((size = (Size)property.getAnnotation(Size.class)) != null) {
            if (size.min() > 0) {
                attributes.put("minimum-length", String.valueOf(size.min()));
            }
            if (size.max() > 0) {
                attributes.put("maximum-length", String.valueOf(size.max()));
            }
        }
        if ((pattern = (Pattern)property.getAnnotation(Pattern.class)) != null) {
            attributes.put("validation-pattern", String.valueOf(pattern.regexp()));
        }
        return attributes;
    }
}

