/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.persistence.parameter;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.milyn.persistence.parameter.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ParameterIndex<K, P extends Parameter<?>> {
    private final Map<K, P> indexMap = new HashMap<K, P>();

    public P register(K value) {
        Parameter<Object> parameter = (Parameter)this.indexMap.get(value);
        if (parameter == null) {
            parameter = this.createParameter(value);
            this.indexMap.put(value, parameter);
        }
        return (P)parameter;
    }

    protected abstract P createParameter(K var1);

    public P getParameter(Object keyValue) {
        return (P)((Parameter)this.indexMap.get(keyValue));
    }

    public boolean containsKey(Object key) {
        return this.indexMap.containsKey(key);
    }

    public boolean containsParameter(Object parameter) {
        return this.indexMap.containsValue(parameter);
    }

    public Map<K, P> getIndexMap() {
        return Collections.unmodifiableMap(this.indexMap);
    }

    public int size() {
        return this.indexMap.size();
    }

    public int hashCode() {
        return ((Object)this.indexMap).hashCode();
    }

    public boolean equals(ParameterIndex<?, ?> rhs) {
        return ((Object)this.indexMap).equals(rhs.indexMap);
    }
}

