/*
 * Decompiled with CFR 0.152.
 */
package org.mlflow_project.apachehttp.impl.io;

import java.io.IOException;
import org.mlflow_project.apachehttp.Header;
import org.mlflow_project.apachehttp.HeaderIterator;
import org.mlflow_project.apachehttp.HttpException;
import org.mlflow_project.apachehttp.HttpMessage;
import org.mlflow_project.apachehttp.io.HttpMessageWriter;
import org.mlflow_project.apachehttp.io.SessionOutputBuffer;
import org.mlflow_project.apachehttp.message.BasicLineFormatter;
import org.mlflow_project.apachehttp.message.LineFormatter;
import org.mlflow_project.apachehttp.params.HttpParams;
import org.mlflow_project.apachehttp.util.Args;
import org.mlflow_project.apachehttp.util.CharArrayBuffer;

public abstract class AbstractMessageWriter<T extends HttpMessage>
implements HttpMessageWriter<T> {
    protected final SessionOutputBuffer sessionBuffer;
    protected final CharArrayBuffer lineBuf;
    protected final LineFormatter lineFormatter;

    @Deprecated
    public AbstractMessageWriter(SessionOutputBuffer buffer, LineFormatter formatter, HttpParams params) {
        Args.notNull(buffer, "Session input buffer");
        this.sessionBuffer = buffer;
        this.lineBuf = new CharArrayBuffer(128);
        this.lineFormatter = formatter != null ? formatter : BasicLineFormatter.INSTANCE;
    }

    public AbstractMessageWriter(SessionOutputBuffer buffer, LineFormatter formatter) {
        this.sessionBuffer = Args.notNull(buffer, "Session input buffer");
        this.lineFormatter = formatter != null ? formatter : BasicLineFormatter.INSTANCE;
        this.lineBuf = new CharArrayBuffer(128);
    }

    protected abstract void writeHeadLine(T var1) throws IOException;

    @Override
    public void write(T message) throws IOException, HttpException {
        Args.notNull(message, "HTTP message");
        this.writeHeadLine(message);
        HeaderIterator it = message.headerIterator();
        while (it.hasNext()) {
            Header header = it.nextHeader();
            this.sessionBuffer.writeLine(this.lineFormatter.formatHeader(this.lineBuf, header));
        }
        this.lineBuf.clear();
        this.sessionBuffer.writeLine(this.lineBuf);
    }
}

