/*
 * Decompiled with CFR 0.152.
 */
package org.mlflow_project.apachehttp.protocol;

import java.io.IOException;
import org.mlflow_project.apachehttp.HttpEntity;
import org.mlflow_project.apachehttp.HttpEntityEnclosingRequest;
import org.mlflow_project.apachehttp.HttpException;
import org.mlflow_project.apachehttp.HttpRequest;
import org.mlflow_project.apachehttp.HttpRequestInterceptor;
import org.mlflow_project.apachehttp.HttpVersion;
import org.mlflow_project.apachehttp.ProtocolVersion;
import org.mlflow_project.apachehttp.annotation.Contract;
import org.mlflow_project.apachehttp.annotation.ThreadingBehavior;
import org.mlflow_project.apachehttp.protocol.HttpContext;
import org.mlflow_project.apachehttp.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestExpectContinue
implements HttpRequestInterceptor {
    private final boolean activeByDefault;

    @Deprecated
    public RequestExpectContinue() {
        this(false);
    }

    public RequestExpectContinue(boolean activeByDefault) {
        this.activeByDefault = activeByDefault;
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            boolean active;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (active = request.getParams().getBooleanParameter("http.protocol.expect-continue", this.activeByDefault))) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

