/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.serialization;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.List;
import org.mockserver.client.serialization.ObjectMapperFactory;
import org.mockserver.client.serialization.Serializer;
import org.mockserver.client.serialization.model.ExpectationDTO;
import org.mockserver.client.serialization.model.HttpResponseDTO;
import org.mockserver.model.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpResponseSerializer
implements Serializer<HttpResponse> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ObjectMapper objectMapper = ObjectMapperFactory.createObjectMapper();

    @Override
    public String serialize(HttpResponse httpResponse) {
        try {
            HttpResponseDTO value = new HttpResponseDTO(httpResponse);
            return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)value);
        }
        catch (Exception e) {
            this.logger.error(String.format("Exception while serializing httpResponse to JSON with value %s", httpResponse), (Throwable)e);
            throw new RuntimeException(String.format("Exception while serializing httpResponse to JSON with value %s", httpResponse), e);
        }
    }

    @Override
    public HttpResponse deserialize(String jsonHttpResponse) {
        HttpResponse httpResponse = null;
        if (jsonHttpResponse != null && !jsonHttpResponse.isEmpty()) {
            try {
                if (!jsonHttpResponse.contains("\"httpResponse\"")) {
                    HttpResponseDTO httpResponseDTO = (HttpResponseDTO)this.objectMapper.readValue(jsonHttpResponse, HttpResponseDTO.class);
                    if (httpResponseDTO != null) {
                        httpResponse = httpResponseDTO.buildObject();
                    }
                } else {
                    ExpectationDTO expectationDTO = (ExpectationDTO)this.objectMapper.readValue(jsonHttpResponse, ExpectationDTO.class);
                    if (expectationDTO != null) {
                        httpResponse = expectationDTO.buildObject().getHttpResponse();
                    }
                }
            }
            catch (Exception e) {
                this.logger.info("Exception while parsing HttpResponse for [" + jsonHttpResponse + "]", (Throwable)e);
                throw new RuntimeException("Exception while parsing HttpResponse for [" + jsonHttpResponse + "]", e);
            }
        }
        return httpResponse;
    }

    @Override
    public Class<HttpResponse> supportsType() {
        return HttpResponse.class;
    }

    public HttpResponse[] deserializeArray(String jsonHttpResponses) {
        HttpResponse[] httpResponses = new HttpResponse[]{};
        if (jsonHttpResponses != null && !jsonHttpResponses.isEmpty()) {
            try {
                HttpResponseDTO[] httpResponseDTOs = (HttpResponseDTO[])this.objectMapper.readValue(jsonHttpResponses, HttpResponseDTO[].class);
                if (httpResponseDTOs != null && httpResponseDTOs.length > 0) {
                    httpResponses = new HttpResponse[httpResponseDTOs.length];
                    for (int i = 0; i < httpResponseDTOs.length; ++i) {
                        httpResponses[i] = httpResponseDTOs[i].buildObject();
                    }
                }
            }
            catch (Exception e) {
                this.logger.error("Exception while parsing response [" + jsonHttpResponses + "] for HttpResponse[]", (Throwable)e);
                throw new RuntimeException("Exception while parsing response [" + jsonHttpResponses + "] for HttpResponse[]", e);
            }
        }
        return httpResponses;
    }

    @Override
    public String serialize(List<HttpResponse> httpResponses) {
        return this.serialize(httpResponses.toArray(new HttpResponse[httpResponses.size()]));
    }

    @Override
    public String serialize(HttpResponse[] httpResponse) {
        try {
            if (httpResponse != null && httpResponse.length > 0) {
                HttpResponseDTO[] httpResponseDTOs = new HttpResponseDTO[httpResponse.length];
                for (int i = 0; i < httpResponse.length; ++i) {
                    httpResponseDTOs[i] = new HttpResponseDTO(httpResponse[i]);
                }
                return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)httpResponseDTOs);
            }
            return "";
        }
        catch (Exception e) {
            this.logger.error("Exception while serializing HttpResponse to JSON with value " + Arrays.asList(httpResponse), (Throwable)e);
            throw new RuntimeException("Exception while serializing HttpResponse to JSON with value " + Arrays.asList(httpResponse), e);
        }
    }
}

