/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.model;

import com.google.common.net.MediaType;
import org.mockserver.client.serialization.Base64Converter;
import org.mockserver.model.Body;

public class BinaryBody
extends Body<byte[]> {
    private final byte[] bytes;

    public BinaryBody(byte[] bytes) {
        this(bytes, null);
    }

    public BinaryBody(byte[] bytes, MediaType contentType) {
        super(Body.Type.BINARY, contentType);
        this.bytes = bytes;
    }

    public static BinaryBody binary(byte[] body) {
        return new BinaryBody(body);
    }

    public static BinaryBody binary(byte[] body, MediaType contentType) {
        return new BinaryBody(body, contentType);
    }

    @Override
    public byte[] getValue() {
        return this.bytes;
    }

    @Override
    public byte[] getRawBytes() {
        return this.bytes;
    }

    @Override
    public String toString() {
        return this.bytes != null ? Base64Converter.bytesToBase64String(this.bytes) : null;
    }
}

