/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.echo.tls;

import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509KeyManager;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.socket.tls.PEMToFile;
import org.mockserver.socket.tls.jdk.CertificateSigningRequest;
import org.mockserver.socket.tls.jdk.X509AndPrivateKey;
import org.mockserver.socket.tls.jdk.X509Generator;
import org.slf4j.event.Level;

public class UniqueCertificateChainSSLContextBuilder {
    public static SSLContext uniqueCertificateChainSSLContext() throws Exception {
        SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
        sslContext.init(new KeyManager[]{new UniqueCertificateChainX509KeyManager()}, InsecureTrustManagerFactory.INSTANCE.getTrustManagers(), null);
        return sslContext;
    }

    private static class UniqueCertificateChainX509KeyManager
    implements X509KeyManager {
        private static final String CLIENT_ALIAS = "client_alias";
        private static final String SERVER_ALIAS = "server_alias";
        private X509AndPrivateKey certificateAuthorityX509AndPrivateKey;
        private X509AndPrivateKey x509AndPrivateKey;

        private UniqueCertificateChainX509KeyManager() {
            MockServerLogger mockServerLogger = new MockServerLogger();
            try {
                X509Generator x509Generator = new X509Generator(mockServerLogger);
                this.certificateAuthorityX509AndPrivateKey = x509Generator.generateRootX509AndPrivateKey(new CertificateSigningRequest().setKeyPairAlgorithm("RSA").setSigningAlgorithm("SHA256withRSA").setCommonName("www.mockserver.com").setKeyPairSize(2048));
                this.x509AndPrivateKey = x509Generator.generateLeafX509AndPrivateKey(new CertificateSigningRequest().setKeyPairAlgorithm("RSA").setSigningAlgorithm("SHA256withRSA").setCommonName("www.mockserver.com").setCommonName(ConfigurationProperties.sslCertificateDomainName()).addSubjectAlternativeNames(ConfigurationProperties.sslSubjectAlternativeNameDomains()).addSubjectAlternativeNames(ConfigurationProperties.sslSubjectAlternativeNameIps()).setKeyPairSize(2048), CertificateSigningRequest.buildDistinguishedName("www.mockserver.com"), this.certificateAuthorityX509AndPrivateKey.getPrivateKey(), PEMToFile.x509FromPEM(this.certificateAuthorityX509AndPrivateKey.getCert()));
            }
            catch (Throwable throwable) {
                mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception create fake certificates and private keys").setThrowable(throwable));
            }
        }

        @Override
        public String[] getClientAliases(String keyType, Principal[] issuers) {
            return new String[]{CLIENT_ALIAS};
        }

        @Override
        public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
            return CLIENT_ALIAS;
        }

        @Override
        public String[] getServerAliases(String keyType, Principal[] issuers) {
            return new String[]{SERVER_ALIAS};
        }

        @Override
        public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
            return SERVER_ALIAS;
        }

        @Override
        public X509Certificate[] getCertificateChain(String alias) {
            return new X509Certificate[]{PEMToFile.x509FromPEM(this.x509AndPrivateKey.getCert()), PEMToFile.x509FromPEM(this.certificateAuthorityX509AndPrivateKey.getCert())};
        }

        @Override
        public PrivateKey getPrivateKey(String alias) {
            return PEMToFile.privateKeyFromPEM(this.x509AndPrivateKey.getPrivateKey());
        }
    }
}

