/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.java;

import com.google.common.base.Strings;
import java.util.List;
import org.mockserver.character.Character;
import org.mockserver.mock.Expectation;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.OpenAPIDefinition;
import org.mockserver.model.RequestDefinition;
import org.mockserver.serialization.java.HttpClassCallbackToJavaSerializer;
import org.mockserver.serialization.java.HttpErrorToJavaSerializer;
import org.mockserver.serialization.java.HttpForwardToJavaSerializer;
import org.mockserver.serialization.java.HttpOverrideForwardedRequestToJavaSerializer;
import org.mockserver.serialization.java.HttpRequestToJavaSerializer;
import org.mockserver.serialization.java.HttpResponseToJavaSerializer;
import org.mockserver.serialization.java.HttpTemplateToJavaSerializer;
import org.mockserver.serialization.java.OpenAPIMatcherToJavaSerializer;
import org.mockserver.serialization.java.TimeToLiveToJavaSerializer;
import org.mockserver.serialization.java.TimesToJavaSerializer;
import org.mockserver.serialization.java.ToJavaSerializer;

public class ExpectationToJavaSerializer
implements ToJavaSerializer<Expectation> {
    public static final int INDENT_SIZE = 8;

    public String serialize(List<Expectation> expectations) {
        StringBuilder output = new StringBuilder();
        for (Expectation expectation : expectations) {
            output.append(this.serialize(0, expectation));
            output.append(Character.NEW_LINE);
            output.append(Character.NEW_LINE);
        }
        return output.toString();
    }

    @Override
    public String serialize(int numberOfSpacesToIndent, Expectation expectation) {
        StringBuffer output = new StringBuffer();
        if (expectation != null) {
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append("new MockServerClient(\"localhost\", 1080)");
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(".when(");
            RequestDefinition requestDefinition = expectation.getHttpRequest();
            if (requestDefinition instanceof HttpRequest) {
                output.append(new HttpRequestToJavaSerializer().serialize(numberOfSpacesToIndent + 1, (HttpRequest)requestDefinition));
            } else if (requestDefinition instanceof OpenAPIDefinition) {
                output.append(new OpenAPIMatcherToJavaSerializer().serialize(numberOfSpacesToIndent + 1, (OpenAPIDefinition)requestDefinition));
            }
            output.append(",");
            if (expectation.getTimes() != null) {
                output.append(new TimesToJavaSerializer().serialize(numberOfSpacesToIndent + 1, expectation.getTimes()));
            } else {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append("null");
            }
            output.append(",");
            if (expectation.getTimeToLive() != null) {
                output.append(new TimeToLiveToJavaSerializer().serialize(numberOfSpacesToIndent + 1, expectation.getTimeToLive()));
            } else {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append("null");
            }
            output.append(",");
            this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(expectation.getPriority());
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(")");
            if (expectation.getHttpResponse() != null) {
                this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(".respond(");
                output.append(new HttpResponseToJavaSerializer().serialize(numberOfSpacesToIndent + 1, expectation.getHttpResponse()));
                this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(")");
            }
            if (expectation.getHttpResponseTemplate() != null) {
                this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(".respond(");
                output.append(new HttpTemplateToJavaSerializer().serialize(numberOfSpacesToIndent + 1, expectation.getHttpResponseTemplate()));
                this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(")");
            }
            if (expectation.getHttpResponseClassCallback() != null) {
                this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(".respond(");
                output.append(new HttpClassCallbackToJavaSerializer().serialize(numberOfSpacesToIndent + 1, expectation.getHttpResponseClassCallback()));
                this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(")");
            }
            if (expectation.getHttpResponseObjectCallback() != null) {
                this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append("/*NOT POSSIBLE TO GENERATE CODE FOR OBJECT CALLBACK*/");
            }
            if (expectation.getHttpForward() != null) {
                this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(".forward(");
                output.append(new HttpForwardToJavaSerializer().serialize(numberOfSpacesToIndent + 1, expectation.getHttpForward()));
                this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(")");
            }
            if (expectation.getHttpOverrideForwardedRequest() != null) {
                this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(".forward(");
                output.append(new HttpOverrideForwardedRequestToJavaSerializer().serialize(numberOfSpacesToIndent + 1, expectation.getHttpOverrideForwardedRequest()));
                this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(")");
            }
            if (expectation.getHttpForwardTemplate() != null) {
                this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(".forward(");
                output.append(new HttpTemplateToJavaSerializer().serialize(numberOfSpacesToIndent + 1, expectation.getHttpForwardTemplate()));
                this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(")");
            }
            if (expectation.getHttpForwardClassCallback() != null) {
                this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(".forward(");
                output.append(new HttpClassCallbackToJavaSerializer().serialize(numberOfSpacesToIndent + 1, expectation.getHttpForwardClassCallback()));
                this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(")");
            }
            if (expectation.getHttpForwardObjectCallback() != null) {
                this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append("/*NOT POSSIBLE TO GENERATE CODE FOR OBJECT CALLBACK*/");
            }
            if (expectation.getHttpError() != null) {
                this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(".error(");
                output.append(new HttpErrorToJavaSerializer().serialize(numberOfSpacesToIndent + 1, expectation.getHttpError()));
                this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(")");
            }
            output.append(";");
        }
        return output.toString();
    }

    private StringBuffer appendNewLineAndIndent(int numberOfSpacesToIndent, StringBuffer output) {
        return output.append(Character.NEW_LINE).append(Strings.padStart((String)"", (int)numberOfSpacesToIndent, (char)' '));
    }
}

