/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.BodyMatcher;
import org.mockserver.matchers.MatchDifference;
import org.mockserver.model.NottableSchemaString;
import org.mockserver.model.NottableString;
import org.slf4j.event.Level;

public class RegexStringMatcher
extends BodyMatcher<NottableString> {
    private static final String[] EXCLUDED_FIELDS = new String[]{"mockServerLogger"};
    private final MockServerLogger mockServerLogger;
    private final NottableString matcher;
    private final boolean controlPlaneMatcher;

    public RegexStringMatcher(MockServerLogger mockServerLogger, boolean controlPlaneMatcher) {
        this.mockServerLogger = mockServerLogger;
        this.controlPlaneMatcher = controlPlaneMatcher;
        this.matcher = null;
    }

    RegexStringMatcher(MockServerLogger mockServerLogger, NottableString matcher, boolean controlPlaneMatcher) {
        this.mockServerLogger = mockServerLogger;
        this.controlPlaneMatcher = controlPlaneMatcher;
        this.matcher = matcher;
    }

    public boolean matches(String matched) {
        return this.matches((MatchDifference)null, NottableString.string(matched));
    }

    @Override
    public boolean matches(MatchDifference context, NottableString matched) {
        boolean result = false;
        if (this.matcher == null || this.matches(this.matcher, matched, true)) {
            result = true;
        }
        if (!result && context != null) {
            context.addDifference(this.mockServerLogger, "string or regex match failed expected:{}found:{}", this.matcher, matched);
        }
        return this.not != result;
    }

    public boolean matches(NottableString matcher, NottableString matched, boolean ignoreCase) {
        if (matcher instanceof NottableSchemaString && matched instanceof NottableSchemaString) {
            return this.controlPlaneMatcher && this.matchesByNottedStrings(matcher, matched, ignoreCase);
        }
        if (matcher instanceof NottableSchemaString) {
            return this.matchesBySchemas((NottableSchemaString)matcher, matched);
        }
        if (matched instanceof NottableSchemaString) {
            return this.controlPlaneMatcher && this.matchesBySchemas((NottableSchemaString)matched, matcher);
        }
        return this.matchesByNottedStrings(matcher, matched, ignoreCase);
    }

    private boolean matchesByNottedStrings(NottableString matcher, NottableString matched, boolean ignoreCase) {
        if (matcher.isNot() && matched.isNot()) {
            return this.matchesByStrings(matcher, matched, ignoreCase);
        }
        return (matcher.isNot() || matched.isNot()) ^ this.matchesByStrings(matcher, matched, ignoreCase);
    }

    private boolean matchesBySchemas(NottableSchemaString schema, NottableString string) {
        return string.isNot() != schema.matches(string.getValue());
    }

    private boolean matchesByStrings(NottableString matcher, NottableString matched, boolean ignoreCase) {
        block21: {
            String matcherValue = matcher.getValue();
            if (StringUtils.isBlank((CharSequence)matcherValue)) {
                return true;
            }
            String matchedValue = matched.getValue();
            if (matchedValue != null) {
                block19: {
                    block18: {
                        if (matchedValue.equals(matcherValue)) {
                            return true;
                        }
                        try {
                            if (matcher.matches(matchedValue)) {
                                return true;
                            }
                        }
                        catch (PatternSyntaxException pse) {
                            if (!MockServerLogger.isEnabled(Level.DEBUG)) break block18;
                            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMessageFormat("error while matching regex [" + matcher + "] for string [" + matched + "] " + pse.getMessage()).setThrowable(pse));
                        }
                    }
                    try {
                        if (this.controlPlaneMatcher && matched.matches(matcherValue)) {
                            return true;
                        }
                        if (MockServerLogger.isEnabled(Level.DEBUG) && matched.matches(matcherValue)) {
                            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMessageFormat("matcher{}would match{}if matcher was used for control plane").setArguments(matcher, matched));
                        }
                    }
                    catch (PatternSyntaxException pse) {
                        if (!this.controlPlaneMatcher || !MockServerLogger.isEnabled(Level.DEBUG)) break block19;
                        this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMessageFormat("error while matching regex [" + matched + "] for string [" + matcher + "] " + pse.getMessage()).setThrowable(pse));
                    }
                }
                if (ignoreCase) {
                    block20: {
                        if (matchedValue.equalsIgnoreCase(matcherValue)) {
                            return true;
                        }
                        try {
                            if (matcher.matchesIgnoreCase(matchedValue)) {
                                return true;
                            }
                        }
                        catch (PatternSyntaxException pse) {
                            if (!MockServerLogger.isEnabled(Level.DEBUG)) break block20;
                            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMessageFormat("error while matching regex [" + matcherValue.toLowerCase() + "] for string [" + matchedValue.toLowerCase() + "] " + pse.getMessage()).setThrowable(pse));
                        }
                    }
                    try {
                        if (this.controlPlaneMatcher && matched.matchesIgnoreCase(matcherValue)) {
                            return true;
                        }
                    }
                    catch (PatternSyntaxException pse) {
                        if (!MockServerLogger.isEnabled(Level.DEBUG)) break block21;
                        this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMessageFormat("error while matching regex [" + matchedValue.toLowerCase() + "] for string [" + matcherValue.toLowerCase() + "] " + pse.getMessage()).setThrowable(pse));
                    }
                }
            }
        }
        return false;
    }

    @Override
    public boolean isBlank() {
        return this.matcher == null || StringUtils.isBlank((CharSequence)this.matcher.getValue());
    }

    @Override
    @JsonIgnore
    protected String[] fieldsExcludedFromEqualsAndHashCode() {
        return EXCLUDED_FIELDS;
    }
}

