/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mock;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.closurecallback.websocketregistry.WebSocketClientRegistry;
import org.mockserver.collections.CircularPriorityQueue;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.HttpRequestMatcher;
import org.mockserver.matchers.MatchDifference;
import org.mockserver.matchers.MatcherBuilder;
import org.mockserver.metrics.Metrics;
import org.mockserver.mock.Expectation;
import org.mockserver.mock.SortableExpectationId;
import org.mockserver.mock.listeners.MockServerMatcherNotifier;
import org.mockserver.model.Action;
import org.mockserver.model.ExpectationId;
import org.mockserver.model.HttpObjectCallback;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.RequestDefinition;
import org.mockserver.scheduler.Scheduler;
import org.slf4j.event.Level;

public class RequestMatchers
extends MockServerMatcherNotifier {
    final CircularPriorityQueue<String, HttpRequestMatcher, SortableExpectationId> httpRequestMatchers = new CircularPriorityQueue<String, HttpRequestMatcher, SortableExpectationId>(ConfigurationProperties.maxExpectations(), SortableExpectationId.EXPECTATION_SORTABLE_PRIORITY_COMPARATOR, httpRequestMatcher -> httpRequestMatcher.getExpectation() != null ? httpRequestMatcher.getExpectation().getSortableId() : SortableExpectationId.NULL, httpRequestMatcher -> httpRequestMatcher.getExpectation() != null ? httpRequestMatcher.getExpectation().getId() : "");
    private final MockServerLogger mockServerLogger;
    private final Scheduler scheduler;
    private WebSocketClientRegistry webSocketClientRegistry;
    private MatcherBuilder matcherBuilder;

    public RequestMatchers(MockServerLogger mockServerLogger, Scheduler scheduler, WebSocketClientRegistry webSocketClientRegistry) {
        super(scheduler);
        this.scheduler = scheduler;
        this.matcherBuilder = new MatcherBuilder(mockServerLogger);
        this.mockServerLogger = mockServerLogger;
        this.webSocketClientRegistry = webSocketClientRegistry;
    }

    public Expectation add(Expectation expectation, MockServerMatcherNotifier.Cause cause) {
        Expectation upsertedExpectation = null;
        if (expectation != null) {
            upsertedExpectation = this.httpRequestMatchers.getByKey(expectation.getId()).map(httpRequestMatcher -> {
                if (httpRequestMatcher.getExpectation() != null && httpRequestMatcher.getExpectation().getAction() != null) {
                    Metrics.decrement(httpRequestMatcher.getExpectation().getAction().getType());
                }
                if (httpRequestMatcher.getExpectation() != null) {
                    expectation.withCreated(httpRequestMatcher.getExpectation().getCreated());
                }
                this.httpRequestMatchers.removePriorityKey((HttpRequestMatcher)httpRequestMatcher);
                if (httpRequestMatcher.update(expectation)) {
                    this.httpRequestMatchers.addPriorityKey((HttpRequestMatcher)httpRequestMatcher);
                    if (MockServerLogger.isEnabled(Level.INFO)) {
                        this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.UPDATED_EXPECTATION).setLogLevel(Level.INFO).setHttpRequest(expectation.getHttpRequest()).setMessageFormat("updated expectation:{}with id:{}").setArguments(expectation.clone(), expectation.getId()));
                    }
                    if (expectation.getAction() != null) {
                        Metrics.increment(expectation.getAction().getType());
                    }
                } else {
                    this.httpRequestMatchers.addPriorityKey((HttpRequestMatcher)httpRequestMatcher);
                }
                return httpRequestMatcher;
            }).orElseGet(() -> this.addPrioritisedExpectation(expectation)).getExpectation();
            this.notifyListeners(this, cause);
        }
        return upsertedExpectation;
    }

    public void update(Expectation[] expectations, MockServerMatcherNotifier.Cause cause) {
        AtomicInteger numberOfChanges = new AtomicInteger(0);
        if (expectations != null) {
            Map<String, HttpRequestMatcher> httpRequestMatchersByKey = this.httpRequestMatchers.keyMap();
            HashSet<String> existingKeys = new HashSet<String>(httpRequestMatchersByKey.keySet());
            Arrays.stream(expectations).forEach(expectation -> {
                existingKeys.remove(expectation.getId());
                if (httpRequestMatchersByKey.containsKey(expectation.getId())) {
                    HttpRequestMatcher httpRequestMatcher = (HttpRequestMatcher)httpRequestMatchersByKey.get(expectation.getId());
                    if (httpRequestMatcher.getExpectation() != null && httpRequestMatcher.getExpectation().getAction() != null) {
                        Metrics.decrement(httpRequestMatcher.getExpectation().getAction().getType());
                    }
                    if (httpRequestMatcher.getExpectation() != null) {
                        expectation.withCreated(httpRequestMatcher.getExpectation().getCreated());
                    }
                    this.httpRequestMatchers.removePriorityKey(httpRequestMatcher);
                    if (httpRequestMatcher.update((Expectation)expectation)) {
                        this.httpRequestMatchers.addPriorityKey(httpRequestMatcher);
                        numberOfChanges.getAndIncrement();
                        if (MockServerLogger.isEnabled(Level.INFO)) {
                            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.UPDATED_EXPECTATION).setLogLevel(Level.INFO).setHttpRequest(expectation.getHttpRequest()).setMessageFormat("updated expectation:{}with id:{}").setArguments(expectation.clone(), expectation.getId()));
                        }
                        if (expectation.getAction() != null) {
                            Metrics.increment(expectation.getAction().getType());
                        }
                    } else {
                        this.httpRequestMatchers.addPriorityKey(httpRequestMatcher);
                    }
                } else {
                    this.addPrioritisedExpectation((Expectation)expectation);
                    numberOfChanges.getAndIncrement();
                }
            });
            existingKeys.forEach(key -> {
                numberOfChanges.getAndIncrement();
                HttpRequestMatcher httpRequestMatcher = (HttpRequestMatcher)httpRequestMatchersByKey.get(key);
                this.removeHttpRequestMatcher(httpRequestMatcher, cause, false);
                if (httpRequestMatcher.getExpectation() != null && httpRequestMatcher.getExpectation().getAction() != null) {
                    Metrics.decrement(httpRequestMatcher.getExpectation().getAction().getType());
                }
            });
            if (numberOfChanges.get() > 0) {
                this.notifyListeners(this, cause);
            }
        }
    }

    private HttpRequestMatcher addPrioritisedExpectation(Expectation expectation) {
        HttpRequestMatcher httpRequestMatcher = this.matcherBuilder.transformsToMatcher(expectation);
        this.httpRequestMatchers.add(httpRequestMatcher);
        if (expectation.getAction() != null) {
            Metrics.increment(expectation.getAction().getType());
        }
        if (MockServerLogger.isEnabled(Level.INFO)) {
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.CREATED_EXPECTATION).setLogLevel(Level.INFO).setHttpRequest(expectation.getHttpRequest()).setMessageFormat("creating expectation:{}with id:{}").setArguments(expectation.clone(), expectation.getId()));
        }
        return httpRequestMatcher;
    }

    public int size() {
        return this.httpRequestMatchers.size();
    }

    public void setMaxSize(int maxSize) {
        this.httpRequestMatchers.setMaxSize(maxSize);
    }

    public void reset(MockServerMatcherNotifier.Cause cause) {
        this.httpRequestMatchers.stream().forEach(httpRequestMatcher -> this.removeHttpRequestMatcher((HttpRequestMatcher)httpRequestMatcher, cause, false));
        Metrics.clearActionMetrics();
        this.notifyListeners(this, cause);
    }

    public void reset() {
        this.reset(MockServerMatcherNotifier.Cause.API);
    }

    public Expectation firstMatchingExpectation(HttpRequest httpRequest) {
        Optional<Expectation> first = this.getHttpRequestMatchersCopy().map(httpRequestMatcher -> {
            Expectation matchingExpectation = null;
            boolean remainingMatchesDecremented = false;
            if (httpRequestMatcher.matches(MockServerLogger.isEnabled(Level.DEBUG) ? new MatchDifference(httpRequest) : null, httpRequest)) {
                matchingExpectation = httpRequestMatcher.getExpectation();
                httpRequestMatcher.setResponseInProgress(true);
                if (matchingExpectation.decrementRemainingMatches()) {
                    remainingMatchesDecremented = true;
                }
            } else if (!httpRequestMatcher.isResponseInProgress() && !httpRequestMatcher.isActive()) {
                this.scheduler.submit(() -> this.removeHttpRequestMatcher((HttpRequestMatcher)httpRequestMatcher));
            }
            if (remainingMatchesDecremented) {
                this.notifyListeners(this, MockServerMatcherNotifier.Cause.API);
            }
            return matchingExpectation;
        }).filter(Objects::nonNull).findFirst();
        if (ConfigurationProperties.metricsEnabled()) {
            if (!first.isPresent() || first.get().getAction() == null) {
                Metrics.increment(Metrics.Name.EXPECTATION_NOT_MATCHED_COUNT);
            } else if (first.get().getAction().getType().direction == Action.Direction.FORWARD) {
                Metrics.increment(Metrics.Name.FORWARD_EXPECTATION_MATCHED_COUNT);
            } else {
                Metrics.increment(Metrics.Name.RESPONSE_EXPECTATION_MATCHED_COUNT);
            }
        }
        return first.orElse(null);
    }

    public void clear(RequestDefinition requestDefinition) {
        if (requestDefinition != null) {
            HttpRequestMatcher clearHttpRequestMatcher = this.matcherBuilder.transformsToMatcher(requestDefinition);
            this.getHttpRequestMatchersCopy().forEach(httpRequestMatcher -> {
                RequestDefinition request = httpRequestMatcher.getExpectation().getHttpRequest();
                if (StringUtils.isNotBlank((CharSequence)requestDefinition.getLogCorrelationId())) {
                    request = request.shallowClone().withLogCorrelationId(requestDefinition.getLogCorrelationId());
                }
                if (clearHttpRequestMatcher.matches(request)) {
                    this.removeHttpRequestMatcher((HttpRequestMatcher)httpRequestMatcher);
                }
            });
            if (MockServerLogger.isEnabled(Level.INFO)) {
                this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.CLEARED).setLogLevel(Level.INFO).setCorrelationId(requestDefinition.getLogCorrelationId()).setHttpRequest(requestDefinition).setMessageFormat("cleared expectations that match:{}").setArguments(requestDefinition));
            }
        } else {
            this.reset();
        }
    }

    Expectation postProcess(Expectation expectation) {
        if (expectation != null) {
            this.getHttpRequestMatchersCopy().filter(httpRequestMatcher -> httpRequestMatcher.getExpectation() == expectation).findFirst().ifPresent(httpRequestMatcher -> {
                if (!expectation.isActive()) {
                    this.removeHttpRequestMatcher((HttpRequestMatcher)httpRequestMatcher);
                }
                httpRequestMatcher.setResponseInProgress(false);
            });
        }
        return expectation;
    }

    private void removeHttpRequestMatcher(HttpRequestMatcher httpRequestMatcher) {
        this.removeHttpRequestMatcher(httpRequestMatcher, MockServerMatcherNotifier.Cause.API, true);
    }

    private void removeHttpRequestMatcher(HttpRequestMatcher httpRequestMatcher, MockServerMatcherNotifier.Cause cause, boolean notifyAndUpdateMetrics) {
        if (this.httpRequestMatchers.remove(httpRequestMatcher)) {
            if (httpRequestMatcher.getExpectation() != null && MockServerLogger.isEnabled(Level.INFO)) {
                Expectation expectation = httpRequestMatcher.getExpectation().clone();
                this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.REMOVED_EXPECTATION).setLogLevel(Level.INFO).setHttpRequest(httpRequestMatcher.getExpectation().getHttpRequest()).setMessageFormat("removed expectation:{}with id:{}").setArguments(expectation, expectation.getId()));
            }
            if (httpRequestMatcher.getExpectation() != null) {
                Action action = httpRequestMatcher.getExpectation().getAction();
                if (action instanceof HttpObjectCallback) {
                    this.webSocketClientRegistry.unregisterClient(((HttpObjectCallback)action).getClientId());
                }
                if (notifyAndUpdateMetrics && action != null) {
                    Metrics.decrement(action.getType());
                }
            }
            if (notifyAndUpdateMetrics) {
                this.notifyListeners(this, cause);
            }
        }
    }

    public Stream<Expectation> retrieveExpectations(ExpectationId ... expectationIds) {
        return Arrays.stream(expectationIds).map(expectationId -> this.httpRequestMatchers.getByKey(expectationId.getId()).map(HttpRequestMatcher::getExpectation)).filter(Optional::isPresent).map(Optional::get);
    }

    public List<Expectation> retrieveActiveExpectations(RequestDefinition requestDefinition) {
        if (requestDefinition == null) {
            return this.httpRequestMatchers.stream().map(HttpRequestMatcher::getExpectation).collect(Collectors.toList());
        }
        ArrayList<Expectation> expectations = new ArrayList<Expectation>();
        HttpRequestMatcher requestMatcher = this.matcherBuilder.transformsToMatcher(requestDefinition);
        this.getHttpRequestMatchersCopy().forEach(httpRequestMatcher -> {
            if (requestMatcher.matches(httpRequestMatcher.getExpectation().getHttpRequest())) {
                expectations.add(httpRequestMatcher.getExpectation());
            }
        });
        return expectations;
    }

    public List<HttpRequestMatcher> retrieveRequestMatchers(RequestDefinition requestDefinition) {
        if (requestDefinition == null) {
            return this.httpRequestMatchers.stream().collect(Collectors.toList());
        }
        ArrayList<HttpRequestMatcher> httpRequestMatchers = new ArrayList<HttpRequestMatcher>();
        HttpRequestMatcher requestMatcher = this.matcherBuilder.transformsToMatcher(requestDefinition);
        this.getHttpRequestMatchersCopy().forEach(httpRequestMatcher -> {
            if (requestMatcher.matches(httpRequestMatcher.getExpectation().getHttpRequest())) {
                httpRequestMatchers.add((HttpRequestMatcher)httpRequestMatcher);
            }
        });
        return httpRequestMatchers;
    }

    public boolean isEmpty() {
        return this.httpRequestMatchers.isEmpty();
    }

    @Override
    protected void notifyListeners(RequestMatchers notifier, MockServerMatcherNotifier.Cause cause) {
        super.notifyListeners(notifier, cause);
    }

    private Stream<HttpRequestMatcher> getHttpRequestMatchersCopy() {
        return this.httpRequestMatchers.stream();
    }
}

