/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mappers;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import javax.servlet.http.HttpServletResponse;
import org.mockserver.codec.BodyServletDecoderEncoder;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.Header;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.NottableString;

public class MockServerHttpResponseToHttpServletResponseEncoder {
    private final BodyServletDecoderEncoder bodyDecoderEncoder;

    public MockServerHttpResponseToHttpServletResponseEncoder(MockServerLogger mockServerLogger) {
        this.bodyDecoderEncoder = new BodyServletDecoderEncoder(mockServerLogger);
    }

    public void mapMockServerResponseToHttpServletResponse(HttpResponse httpResponse, HttpServletResponse httpServletResponse) {
        this.setStatusCode(httpResponse, httpServletResponse);
        this.setHeaders(httpResponse, httpServletResponse);
        this.setCookies(httpResponse, httpServletResponse);
        this.setBody(httpResponse, httpServletResponse);
    }

    private void setStatusCode(HttpResponse httpResponse, HttpServletResponse httpServletResponse) {
        int statusCode;
        int n = statusCode = httpResponse.getStatusCode() != null ? httpResponse.getStatusCode() : 200;
        if (httpResponse.getReasonPhrase() != null) {
            httpServletResponse.setStatus(statusCode, httpResponse.getReasonPhrase());
        } else {
            httpServletResponse.setStatus(statusCode);
        }
    }

    private void setHeaders(HttpResponse httpResponse, HttpServletResponse httpServletResponse) {
        if (httpResponse.getHeaderList() != null) {
            for (Header header : httpResponse.getHeaderList()) {
                String headerName = header.getName().getValue();
                if (headerName.equalsIgnoreCase(HttpHeaderNames.CONTENT_LENGTH.toString()) || headerName.equalsIgnoreCase(HttpHeaderNames.TRANSFER_ENCODING.toString()) || headerName.equalsIgnoreCase(HttpHeaderNames.HOST.toString()) || headerName.equalsIgnoreCase(HttpHeaderNames.ACCEPT_ENCODING.toString()) || headerName.equalsIgnoreCase(HttpHeaderNames.CONNECTION.toString())) continue;
                for (NottableString value : header.getValues()) {
                    httpServletResponse.addHeader(headerName, value.getValue());
                }
            }
        }
        this.addContentTypeHeader(httpResponse, httpServletResponse);
    }

    private void setCookies(HttpResponse httpResponse, HttpServletResponse httpServletResponse) {
        if (httpResponse.getCookieList() != null) {
            for (org.mockserver.model.Cookie cookie : httpResponse.getCookieList()) {
                if (!httpResponse.cookieHeaderDoesNotAlreadyExists(cookie)) continue;
                httpServletResponse.addHeader(HttpHeaderNames.SET_COOKIE.toString(), ServerCookieEncoder.LAX.encode((Cookie)new DefaultCookie(cookie.getName().getValue(), cookie.getValue().getValue())));
            }
        }
    }

    private void setBody(HttpResponse httpResponse, HttpServletResponse httpServletResponse) {
        this.bodyDecoderEncoder.bodyToServletResponse(httpServletResponse, httpResponse.getBody(), httpResponse.getFirstHeader(HttpHeaderNames.CONTENT_TYPE.toString()));
    }

    private void addContentTypeHeader(HttpResponse httpResponse, HttpServletResponse httpServletResponse) {
        if (httpServletResponse.getContentType() == null && httpResponse.getBody() != null && httpResponse.getBody().getContentType() != null) {
            httpServletResponse.addHeader(HttpHeaderNames.CONTENT_TYPE.toString(), httpResponse.getBody().getContentType());
        }
    }
}

