/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.serializers.request;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.model.HttpRequest;

public class HttpRequestSerializer
extends StdSerializer<HttpRequest> {
    public HttpRequestSerializer() {
        super(HttpRequest.class);
    }

    public void serialize(HttpRequest httpRequest, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        if (httpRequest.getNot() != null && httpRequest.getNot().booleanValue()) {
            jgen.writeBooleanField("not", httpRequest.getNot().booleanValue());
        }
        if (httpRequest.getMethod() != null && !httpRequest.getMethod().isBlank()) {
            jgen.writeObjectField("method", (Object)httpRequest.getMethod());
        }
        if (httpRequest.getPath() != null && !httpRequest.getPath().isBlank()) {
            jgen.writeObjectField("path", (Object)httpRequest.getPath());
        }
        if (httpRequest.getPathParameters() != null && !httpRequest.getPathParameters().isEmpty()) {
            jgen.writeObjectField("pathParameters", (Object)httpRequest.getPathParameters());
        }
        if (httpRequest.getQueryStringParameterList() != null && !httpRequest.getQueryStringParameterList().isEmpty()) {
            jgen.writeObjectField("queryStringParameters", (Object)httpRequest.getQueryStringParameters());
        }
        if (httpRequest.getHeaderList() != null && !httpRequest.getHeaderList().isEmpty()) {
            jgen.writeObjectField("headers", (Object)httpRequest.getHeaders());
        }
        if (httpRequest.getCookieList() != null && !httpRequest.getCookieList().isEmpty()) {
            jgen.writeObjectField("cookies", (Object)httpRequest.getCookies());
        }
        if (httpRequest.isKeepAlive() != null) {
            jgen.writeBooleanField("keepAlive", httpRequest.isKeepAlive().booleanValue());
        }
        if (httpRequest.isSecure() != null) {
            jgen.writeBooleanField("secure", httpRequest.isSecure().booleanValue());
        }
        if (httpRequest.getClientCertificateChain() != null && !httpRequest.getClientCertificateChain().isEmpty()) {
            jgen.writeObjectField("clientCertificateChain", httpRequest.getClientCertificateChain());
        }
        if (httpRequest.getSocketAddress() != null) {
            jgen.writeObjectField("socketAddress", (Object)httpRequest.getSocketAddress());
        }
        if (httpRequest.getProtocol() != null) {
            jgen.writeStringField("protocol", httpRequest.getProtocol().name());
        }
        if (StringUtils.isNotBlank((CharSequence)httpRequest.getLocalAddress())) {
            jgen.writeObjectField("localAddress", (Object)httpRequest.getLocalAddress());
        }
        if (StringUtils.isNotBlank((CharSequence)httpRequest.getRemoteAddress())) {
            jgen.writeObjectField("remoteAddress", (Object)httpRequest.getRemoteAddress());
        }
        if (httpRequest.getBody() != null && StringUtils.isNotBlank((CharSequence)String.valueOf(httpRequest.getBody().getValue()))) {
            jgen.writeObjectField("body", (Object)httpRequest.getBody());
        }
        jgen.writeEndObject();
    }
}

