/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.templates.engine.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.mockserver.model.Cookie;
import org.mockserver.model.Header;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.NottableString;
import org.mockserver.model.Parameter;
import org.mockserver.model.RequestDefinition;
import org.mockserver.model.X509Certificate;
import org.mockserver.serialization.model.BodyDTO;

public class HttpRequestTemplateObject
extends RequestDefinition {
    private int hashCode;
    private String method = "";
    private String path = "";
    private final Map<String, List<String>> pathParameters = new HashMap<String, List<String>>();
    private final Map<String, List<String>> queryStringParameters = new HashMap<String, List<String>>();
    private final Map<String, String> cookies = new HashMap<String, String>();
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private BodyDTO body = null;
    private Boolean secure = null;
    private List<X509Certificate> clientCertificateChain = null;
    private String localAddress = null;
    private String remoteAddress = null;
    private Boolean keepAlive = null;

    public HttpRequestTemplateObject(HttpRequest httpRequest) {
        if (httpRequest != null) {
            this.method = httpRequest.getMethod().getValue();
            this.path = httpRequest.getPath().getValue();
            for (Parameter parameter : httpRequest.getPathParameterList()) {
                this.pathParameters.put(parameter.getName().getValue(), parameter.getValues().stream().map(NottableString::getValue).collect(Collectors.toList()));
            }
            for (Parameter parameter : httpRequest.getQueryStringParameterList()) {
                this.queryStringParameters.put(parameter.getName().getValue(), parameter.getValues().stream().map(NottableString::getValue).collect(Collectors.toList()));
            }
            for (Header header : httpRequest.getHeaderList()) {
                this.headers.put(header.getName().getValue(), header.getValues().stream().map(NottableString::getValue).collect(Collectors.toList()));
            }
            for (Cookie cookie : httpRequest.getCookieList()) {
                this.cookies.put(cookie.getName().getValue(), cookie.getValue().getValue());
            }
            this.body = BodyDTO.createDTO(httpRequest.getBody());
            this.secure = httpRequest.isSecure();
            this.clientCertificateChain = httpRequest.getClientCertificateChain();
            this.localAddress = httpRequest.getLocalAddress();
            this.remoteAddress = httpRequest.getRemoteAddress();
            this.keepAlive = httpRequest.isKeepAlive();
            this.setNot(httpRequest.getNot());
        }
    }

    public String getMethod() {
        return this.method;
    }

    public String getPath() {
        return this.path;
    }

    public Map<String, List<String>> getPathParameters() {
        return this.pathParameters;
    }

    public Map<String, List<String>> getQueryStringParameters() {
        return this.queryStringParameters;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public Map<String, String> getCookies() {
        return this.cookies;
    }

    public String getBody() {
        return BodyDTO.toString(this.body);
    }

    @Deprecated
    public String getBodyAsString() {
        return BodyDTO.toString(this.body);
    }

    public Boolean getSecure() {
        return this.secure;
    }

    public List<X509Certificate> getClientCertificateChain() {
        return this.clientCertificateChain;
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public Boolean getKeepAlive() {
        return this.keepAlive;
    }

    @Override
    public HttpRequestTemplateObject shallowClone() {
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (this.hashCode() != o.hashCode()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HttpRequestTemplateObject that = (HttpRequestTemplateObject)o;
        return Objects.equals(this.method, that.method) && Objects.equals(this.path, that.path) && Objects.equals(this.pathParameters, that.pathParameters) && Objects.equals(this.queryStringParameters, that.queryStringParameters) && Objects.equals(this.cookies, that.cookies) && Objects.equals(this.headers, that.headers) && Objects.equals(this.body, that.body) && Objects.equals(this.secure, that.secure) && Objects.equals(this.localAddress, that.localAddress) && Objects.equals(this.remoteAddress, that.remoteAddress) && Objects.equals(this.keepAlive, that.keepAlive);
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Objects.hash(super.hashCode(), this.method, this.path, this.pathParameters, this.queryStringParameters, this.cookies, this.headers, this.body, this.secure, this.localAddress, this.remoteAddress, this.keepAlive);
        }
        return this.hashCode;
    }
}

