/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.netty;

import com.google.common.util.concurrent.SettableFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.ssl.NotSslRecordException;
import javax.net.ssl.SSLException;
import org.mockserver.client.netty.NettyHttpClient;
import org.mockserver.log.model.MessageLogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.HttpResponse;

@ChannelHandler.Sharable
public class HttpClientHandler
extends SimpleChannelInboundHandler<HttpResponse> {
    private final MockServerLogger mockServerLogger;

    public HttpClientHandler(MockServerLogger mockServerLogger) {
        super(false);
        this.mockServerLogger = mockServerLogger;
    }

    public void channelRead0(ChannelHandlerContext ctx, HttpResponse response) {
        ((SettableFuture)ctx.channel().attr(NettyHttpClient.RESPONSE_FUTURE).get()).set((Object)response);
        ctx.close();
        if (!response.containsHeader("x-forwarded-by", "MockServer")) {
            this.mockServerLogger.debug(MessageLogEntry.LogMessageType.FORWARDED_REQUEST, "Sent request to: {}request: {}and received response: {}", ctx.channel().attr(NettyHttpClient.REMOTE_SOCKET).get(), ctx.channel().attr(NettyHttpClient.REQUEST).get(), response);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (this.isNotSslException(cause)) {
            cause.printStackTrace();
        }
        ((SettableFuture)ctx.channel().attr(NettyHttpClient.RESPONSE_FUTURE).get()).setException(cause);
        ctx.close();
    }

    private boolean isNotSslException(Throwable cause) {
        return !(cause.getCause() instanceof SSLException) && !(cause instanceof DecoderException | cause instanceof NotSslRecordException);
    }
}

