/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.netty.codec.mappers;

import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.cookie.ClientCookieDecoder;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import java.nio.charset.Charset;
import org.mockserver.mappers.ContentTypeMapper;
import org.mockserver.model.BinaryBody;
import org.mockserver.model.Cookies;
import org.mockserver.model.Header;
import org.mockserver.model.Headers;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.NottableString;

public class FullHttpResponseToMockServerResponse {
    public HttpResponse mapMockServerResponseToFullHttpResponse(FullHttpResponse fullHttpResponse) {
        HttpResponse httpResponse = new HttpResponse();
        if (fullHttpResponse != null) {
            this.setStatusCode(httpResponse, fullHttpResponse);
            this.setHeaders(httpResponse, fullHttpResponse);
            this.setCookies(httpResponse);
            this.setBody(httpResponse, fullHttpResponse);
        }
        return httpResponse;
    }

    private void setStatusCode(HttpResponse httpResponse, FullHttpResponse fullHttpResponse) {
        HttpResponseStatus status = fullHttpResponse.status();
        httpResponse.withStatusCode(status.code());
        httpResponse.withReasonPhrase(status.reasonPhrase());
    }

    private void setHeaders(HttpResponse httpResponse, FullHttpResponse fullHttpResponse) {
        Headers headers = new Headers(new Header[0]);
        for (String headerName : fullHttpResponse.headers().names()) {
            headers.withEntry(new Header(headerName, fullHttpResponse.headers().getAll(headerName)));
        }
        if (!headers.isEmpty()) {
            httpResponse.withHeaders(headers);
        }
    }

    private void setCookies(HttpResponse httpResponse) {
        Cookies cookies = new Cookies(new org.mockserver.model.Cookie[0]);
        for (Header header : httpResponse.getHeaderList()) {
            if (header.getName().getValue().equalsIgnoreCase("Set-Cookie")) {
                for (NottableString cookieHeader : header.getValues()) {
                    Cookie httpCookie = ClientCookieDecoder.LAX.decode(cookieHeader.getValue());
                    String name = httpCookie.name().trim();
                    String value = httpCookie.value().trim();
                    cookies.withEntry(new org.mockserver.model.Cookie(name, value));
                }
            }
            if (!header.getName().getValue().equalsIgnoreCase("Cookie")) continue;
            for (NottableString cookieHeader : header.getValues()) {
                for (Cookie httpCookie : ServerCookieDecoder.LAX.decode(cookieHeader.getValue())) {
                    String name = httpCookie.name().trim();
                    String value = httpCookie.value().trim();
                    cookies.withEntry(new org.mockserver.model.Cookie(name, value));
                }
            }
        }
        if (!cookies.isEmpty()) {
            httpResponse.withCookies(cookies);
        }
    }

    private void setBody(HttpResponse httpResponse, FullHttpResponse fullHttpResponse) {
        if (fullHttpResponse.content().readableBytes() > 0) {
            byte[] bodyBytes = new byte[fullHttpResponse.content().readableBytes()];
            fullHttpResponse.content().readBytes(bodyBytes);
            if (bodyBytes.length > 0) {
                if (ContentTypeMapper.isBinary(fullHttpResponse.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE))) {
                    httpResponse.withBody(new BinaryBody(bodyBytes));
                } else {
                    Charset requestCharset = ContentTypeMapper.getCharsetFromContentTypeHeader(fullHttpResponse.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE));
                    httpResponse.withBody(new String(bodyBytes, requestCharset));
                }
            }
        }
    }
}

