/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.serialization.deserializers.collections;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.io.IOException;
import org.mockserver.model.Cookie;
import org.mockserver.model.Cookies;
import org.mockserver.model.NottableString;

public class CookiesDeserializer
extends StdDeserializer<Cookies> {
    public CookiesDeserializer() {
        super(Cookies.class);
    }

    public Cookies deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.isExpectedStartArrayToken()) {
            return this.deserializeArray(p, ctxt, ctxt.getNodeFactory());
        }
        if (p.isExpectedStartObjectToken()) {
            return this.deserializeObject(p, ctxt, ctxt.getNodeFactory());
        }
        return (Cookies)ctxt.handleUnexpectedToken(Cookies.class, p);
    }

    private Cookies deserializeObject(JsonParser jsonParser, DeserializationContext ctxt, JsonNodeFactory nodeFactory) throws IOException {
        JsonToken t;
        Cookies cookies = new Cookies(new Cookie[0]);
        NottableString key = NottableString.string("");
        block5: while (true) {
            t = jsonParser.nextToken();
            switch (t.id()) {
                case 5: {
                    key = NottableString.string(jsonParser.getText());
                    continue block5;
                }
                case 6: {
                    cookies.withEntry(key, NottableString.string((String)ctxt.readValue(jsonParser, String.class)));
                    continue block5;
                }
                case 2: {
                    return cookies;
                }
            }
            break;
        }
        throw new RuntimeException("Unexpected token: \"" + t + "\" id: \"" + t.id() + "\" text: \"" + jsonParser.getText());
    }

    private Cookies deserializeArray(JsonParser jsonParser, DeserializationContext ctxt, JsonNodeFactory nodeFactory) throws IOException {
        JsonToken t;
        Cookies headers = new Cookies(new Cookie[0]);
        NottableString key = null;
        NottableString value = null;
        String fieldName = null;
        block7: while (true) {
            t = jsonParser.nextToken();
            switch (t.id()) {
                case 4: {
                    return headers;
                }
                case 1: {
                    key = null;
                    value = null;
                    continue block7;
                }
                case 5: {
                    fieldName = jsonParser.getText();
                    continue block7;
                }
                case 6: {
                    if ("name".equals(fieldName)) {
                        key = NottableString.string((String)ctxt.readValue(jsonParser, String.class));
                        continue block7;
                    }
                    if (!"value".equals(fieldName)) continue block7;
                    value = NottableString.string((String)ctxt.readValue(jsonParser, String.class));
                    continue block7;
                }
                case 2: {
                    headers.withEntry(key, value);
                    continue block7;
                }
            }
            break;
        }
        throw new RuntimeException("Unexpected token: \"" + t + "\" id: \"" + t.id() + "\" text: \"" + jsonParser.getText());
    }
}

