/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.serialization.java;

import com.google.common.base.Strings;
import org.mockserver.character.Character;
import org.mockserver.client.serialization.java.ToJavaSerializer;
import org.mockserver.matchers.Times;

public class TimesToJavaSerializer
implements ToJavaSerializer<Times> {
    @Override
    public String serialize(int numberOfSpacesToIndent, Times times) {
        StringBuffer output = new StringBuffer();
        if (times != null) {
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output);
            if (times.isUnlimited()) {
                output.append("Times.unlimited()");
            } else if (times.getRemainingTimes() == 1) {
                output.append("Times.once()");
            } else {
                output.append("Times.exactly(").append(times.getRemainingTimes()).append(")");
            }
        }
        return output.toString();
    }

    private StringBuffer appendNewLineAndIndent(int numberOfSpacesToIndent, StringBuffer output) {
        return output.append(Character.NEW_LINE).append(Strings.padStart((String)"", (int)numberOfSpacesToIndent, (char)' '));
    }
}

