/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mock;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mockserver.collections.CircularLinkedList;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.HttpRequestMatcher;
import org.mockserver.matchers.MatcherBuilder;
import org.mockserver.mock.Expectation;
import org.mockserver.model.HttpRequest;
import org.mockserver.scheduler.Scheduler;
import org.mockserver.ui.MockServerMatcherNotifier;

public class MockServerMatcher
extends MockServerMatcherNotifier {
    protected final List<HttpRequestMatcher> httpRequestMatchers = Collections.synchronizedList(new CircularLinkedList(ConfigurationProperties.maxExpectations()));
    private MatcherBuilder matcherBuilder;

    MockServerMatcher(MockServerLogger logFormatter, Scheduler scheduler) {
        super(scheduler);
        this.matcherBuilder = new MatcherBuilder(logFormatter);
    }

    public synchronized void add(Expectation expectation) {
        this.httpRequestMatchers.add(this.matcherBuilder.transformsToMatcher(expectation));
        this.notifyListeners(this);
    }

    private synchronized List<HttpRequestMatcher> cloneMatchers() {
        return new ArrayList<HttpRequestMatcher>(this.httpRequestMatchers);
    }

    public synchronized void reset() {
        this.httpRequestMatchers.clear();
        this.notifyListeners(this);
    }

    public Expectation firstMatchingExpectation(HttpRequest httpRequest) {
        Expectation matchingExpectation = null;
        for (HttpRequestMatcher httpRequestMatcher : this.cloneMatchers()) {
            if (httpRequestMatcher.matches(httpRequest, httpRequest)) {
                matchingExpectation = httpRequestMatcher.decrementRemainingMatches();
            }
            if (!httpRequestMatcher.isActive() && this.httpRequestMatchers.contains(httpRequestMatcher)) {
                this.httpRequestMatchers.remove(httpRequestMatcher);
                this.notifyListeners(this);
            }
            if (matchingExpectation == null) continue;
            break;
        }
        return matchingExpectation;
    }

    public void clear(HttpRequest httpRequest) {
        if (httpRequest != null) {
            HttpRequestMatcher clearHttpRequestMatcher = this.matcherBuilder.transformsToMatcher(httpRequest);
            for (HttpRequestMatcher httpRequestMatcher : this.cloneMatchers()) {
                if (!clearHttpRequestMatcher.matches(httpRequestMatcher.getExpectation().getHttpRequest()) || !this.httpRequestMatchers.contains(httpRequestMatcher)) continue;
                this.httpRequestMatchers.remove(httpRequestMatcher);
                this.notifyListeners(this);
            }
        } else {
            this.reset();
        }
    }

    public List<Expectation> retrieveExpectations(HttpRequest httpRequest) {
        ArrayList<Expectation> expectations = new ArrayList<Expectation>();
        HttpRequestMatcher requestMatcher = this.matcherBuilder.transformsToMatcher(httpRequest);
        for (HttpRequestMatcher httpRequestMatcher : this.cloneMatchers()) {
            if (httpRequest != null && !requestMatcher.matches(httpRequestMatcher.getExpectation().getHttpRequest())) continue;
            expectations.add(httpRequestMatcher.getExpectation());
        }
        return expectations;
    }

    public boolean isEmpty() {
        return this.httpRequestMatchers.isEmpty();
    }
}

