/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mock.action;

import com.google.common.util.concurrent.SettableFuture;
import java.net.InetSocketAddress;
import javax.annotation.Nullable;
import org.mockserver.client.netty.NettyHttpClient;
import org.mockserver.filters.HopByHopHeaderFilter;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;

public abstract class HttpForwardAction {
    protected final MockServerLogger mockServerLogger;
    private final NettyHttpClient httpClient;
    private HopByHopHeaderFilter hopByHopHeaderFilter = new HopByHopHeaderFilter();

    HttpForwardAction(MockServerLogger mockServerLogger, NettyHttpClient httpClient) {
        this.mockServerLogger = mockServerLogger;
        this.httpClient = httpClient;
    }

    protected SettableFuture<HttpResponse> sendRequest(HttpRequest httpRequest, @Nullable InetSocketAddress remoteAddress) {
        try {
            return this.httpClient.sendRequest(this.hopByHopHeaderFilter.onRequest(httpRequest), remoteAddress);
        }
        catch (Exception e) {
            this.mockServerLogger.error(httpRequest, (Throwable)e, "Exception forwarding request " + httpRequest, new Object[0]);
            return this.notFoundFuture();
        }
    }

    SettableFuture<HttpResponse> notFoundFuture() {
        SettableFuture notFoundFuture = SettableFuture.create();
        notFoundFuture.set((Object)HttpResponse.notFoundResponse());
        return notFoundFuture;
    }
}

