/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.net.MediaType;
import java.nio.charset.Charset;
import org.mockserver.model.Body;

public abstract class BodyWithContentType<T>
extends Body {
    protected final MediaType contentType;

    public BodyWithContentType(Body.Type type, MediaType contentType) {
        super(type);
        this.contentType = contentType;
    }

    @JsonIgnore
    Charset determineCharacterSet(MediaType contentType, Charset defaultCharset) {
        if (contentType != null && contentType.charset().isPresent()) {
            return (Charset)contentType.charset().get();
        }
        return defaultCharset;
    }

    @Override
    @JsonIgnore
    public Charset getCharset(Charset defaultIfNotSet) {
        return this.determineCharacterSet(this.contentType, defaultIfNotSet);
    }

    @Override
    public String getContentType() {
        return this.contentType != null ? this.contentType.toString() : null;
    }
}

