/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.streams;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.io.IOUtils;
import org.mockserver.character.Character;
import org.mockserver.logging.MockServerLogger;

public class IOStreamUtils {
    private static final MockServerLogger MOCK_SERVER_LOGGER = new MockServerLogger(IOStreamUtils.class);

    public static String readInputStreamToString(Socket socket) throws IOException {
        String line;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        StringBuilder result = new StringBuilder();
        Integer contentLength = null;
        while ((line = bufferedReader.readLine()) != null) {
            if (line.startsWith("content-length") || line.startsWith("Content-Length")) {
                contentLength = Integer.parseInt(line.split(":")[1].trim());
            }
            if (line.length() == 0) {
                if (contentLength == null) break;
                result.append(Character.NEW_LINE);
                for (int position = 0; position < contentLength; ++position) {
                    result.append((char)bufferedReader.read());
                }
                break;
            }
            result.append(line).append(Character.NEW_LINE);
        }
        return result.toString();
    }

    public static String readInputStreamToString(ServletRequest request) {
        try {
            return IOUtils.toString((InputStream)request.getInputStream(), (String)StandardCharsets.UTF_8.name());
        }
        catch (IOException ioe) {
            MOCK_SERVER_LOGGER.error("IOException while reading HttpServletRequest input stream", ioe);
            throw new RuntimeException("IOException while reading HttpServletRequest input stream", ioe);
        }
    }

    public static byte[] readInputStreamToByteArray(ServletRequest request) {
        try {
            return IOUtils.toByteArray((InputStream)request.getInputStream());
        }
        catch (IOException ioe) {
            MOCK_SERVER_LOGGER.error("IOException while reading HttpServletRequest input stream", ioe);
            throw new RuntimeException("IOException while reading HttpServletRequest input stream", ioe);
        }
    }

    public static void writeToOutputStream(byte[] data, ServletResponse response) {
        try {
            ServletOutputStream output = response.getOutputStream();
            output.write(data);
            output.close();
        }
        catch (IOException ioe) {
            MOCK_SERVER_LOGGER.error(String.format("IOException while writing [%s] to HttpServletResponse output stream", new String(data)), ioe);
            throw new RuntimeException(String.format("IOException while writing [%s] to HttpServletResponse output stream", new String(data)), ioe);
        }
    }

    public static ByteBuffer createBasicByteBuffer(String input) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(input.length()).put(input.getBytes(StandardCharsets.UTF_8));
        byteBuffer.flip();
        return byteBuffer;
    }
}

