/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.validator.xmlschema;

import com.google.common.base.Strings;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.mockserver.file.FileReader;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.ObjectWithReflectiveEqualsHashCodeToString;
import org.mockserver.validator.Validator;
import org.xml.sax.SAXException;

public class XmlSchemaValidator
extends ObjectWithReflectiveEqualsHashCodeToString
implements Validator<String> {
    private static final SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
    private final MockServerLogger mockServerLogger;
    private final Schema schema;

    public XmlSchemaValidator(MockServerLogger mockServerLogger, String schema) {
        block5: {
            this.mockServerLogger = mockServerLogger;
            try {
                if (schema.trim().endsWith(">") || Strings.isNullOrEmpty((String)schema)) {
                    this.schema = schemaFactory.newSchema(new StreamSource(new StringReader(schema)));
                    break block5;
                }
                if (schema.trim().endsWith(".xsd")) {
                    this.schema = schemaFactory.newSchema(new StreamSource(FileReader.openReaderToFileFromClassPathOrPath(schema)));
                    break block5;
                }
                throw new IllegalArgumentException("Schema must either be a path reference to a *.xsd file or an xml string");
            }
            catch (SAXException e) {
                throw new IllegalArgumentException("Schema is not valid", e);
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException("Schema file not found", e);
            }
        }
    }

    @Override
    public String isValid(String xml) {
        String errorMessage = "";
        try {
            try {
                this.schema.newValidator().validate(new StreamSource(new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8))));
            }
            catch (SAXException e) {
                errorMessage = e.getMessage();
            }
        }
        catch (Exception e) {
            this.mockServerLogger.error("Exception validating JSON", e);
            return e.getClass().getSimpleName() + " - " + e.getMessage();
        }
        return errorMessage;
    }
}

