/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.util.Arrays;
import java.util.List;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.serialization.ObjectMapperFactory;
import org.slf4j.event.Level;

public class LogEntrySerializer {
    private final MockServerLogger mockServerLogger;
    private final ObjectWriter objectWriter;

    public LogEntrySerializer(MockServerLogger mockServerLogger) {
        this.mockServerLogger = mockServerLogger;
        DefaultPrettyPrinter prettyPrinter = new DefaultPrettyPrinter().withArrayIndenter((DefaultPrettyPrinter.Indenter)DefaultIndenter.SYSTEM_LINEFEED_INSTANCE).withObjectIndenter((DefaultPrettyPrinter.Indenter)DefaultIndenter.SYSTEM_LINEFEED_INSTANCE);
        this.objectWriter = ObjectMapperFactory.createObjectMapper(new JsonSerializer[0]).writer((PrettyPrinter)prettyPrinter);
    }

    public String serialize(LogEntry logEntry) {
        try {
            return this.objectWriter.writeValueAsString((Object)logEntry);
        }
        catch (Exception e) {
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("Exception while serializing LogEntry to JSON with value " + logEntry).setThrowable(e));
            throw new RuntimeException("Exception while serializing LogEntry to JSON with value " + logEntry, e);
        }
    }

    public String serialize(List<LogEntry> logEntries) {
        return this.serialize(logEntries.toArray(new LogEntry[0]));
    }

    public String serialize(LogEntry ... logEntries) {
        try {
            if (logEntries != null && logEntries.length > 0) {
                return this.objectWriter.writeValueAsString((Object)logEntries);
            }
            return "[]";
        }
        catch (Exception e) {
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("Exception while serializing LogEntry to JSON with value " + Arrays.asList(logEntries)).setThrowable(e));
            throw new RuntimeException("Exception while serializing LogEntry to JSON with value " + Arrays.asList(logEntries), e);
        }
    }
}

