/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.model;

import org.mockserver.model.ObjectWithReflectiveEqualsHashCodeToString;
import org.mockserver.model.SocketAddress;
import org.mockserver.serialization.model.DTO;

public class SocketAddressDTO
extends ObjectWithReflectiveEqualsHashCodeToString
implements DTO<SocketAddress> {
    private String host;
    private Integer port;
    private SocketAddress.Scheme scheme;

    public SocketAddressDTO(SocketAddress socketAddress) {
        if (socketAddress != null) {
            this.host = socketAddress.getHost();
            this.port = socketAddress.getPort();
            this.scheme = socketAddress.getScheme();
        }
    }

    public SocketAddressDTO() {
    }

    @Override
    public SocketAddress buildObject() {
        return new SocketAddress().withHost(this.host).withPort(this.port != null ? this.port : 80).withScheme(this.scheme != null ? this.scheme : SocketAddress.Scheme.HTTP);
    }

    public String getHost() {
        return this.host;
    }

    public SocketAddressDTO setHost(String host) {
        this.host = host;
        return this;
    }

    public Integer getPort() {
        return this.port;
    }

    public SocketAddressDTO setPort(Integer port) {
        this.port = port;
        return this;
    }

    public SocketAddress.Scheme getScheme() {
        return this.scheme;
    }

    public SocketAddressDTO setScheme(SocketAddress.Scheme scheme) {
        this.scheme = scheme;
        return this;
    }
}

