/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.concurrent.TimeUnit;
import org.mockserver.matchers.TimeToLive;
import org.mockserver.model.ObjectWithReflectiveEqualsHashCodeToString;
import org.mockserver.serialization.model.DTO;

public class TimeToLiveDTO
extends ObjectWithReflectiveEqualsHashCodeToString
implements DTO<TimeToLive> {
    private static final String[] EXCLUDED_FIELDS = new String[]{"key", "endDate"};
    private TimeUnit timeUnit;
    private Long timeToLive;
    private Long endDate;
    private boolean unlimited;

    public TimeToLiveDTO(TimeToLive timeToLive) {
        this.timeUnit = timeToLive.getTimeUnit();
        this.timeToLive = timeToLive.getTimeToLive();
        this.endDate = timeToLive.getEndDate();
        this.unlimited = timeToLive.isUnlimited();
    }

    public TimeToLiveDTO() {
    }

    @Override
    public TimeToLive buildObject() {
        if (this.unlimited) {
            return TimeToLive.unlimited();
        }
        TimeToLive exactly = TimeToLive.exactly(this.timeUnit, this.timeToLive);
        if (this.endDate != null) {
            exactly.setEndDate(this.endDate);
        }
        return exactly;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public Long getTimeToLive() {
        return this.timeToLive;
    }

    public Long getEndDate() {
        return this.endDate;
    }

    public boolean isUnlimited() {
        return this.unlimited;
    }

    @Override
    @JsonIgnore
    protected String[] fieldsExcludedFromEqualsAndHashCode() {
        return EXCLUDED_FIELDS;
    }
}

