/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.formatting;

import org.mockserver.character.Character;

public class StringFormatter {
    public static StringBuilder[] indentAndToString(Object ... objects) {
        StringBuilder[] indentedObjects = new StringBuilder[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            indentedObjects[i] = new StringBuilder(Character.NEW_LINE).append(Character.NEW_LINE).append(String.valueOf(objects[i]).replaceAll("(?m)^", "\t")).append(Character.NEW_LINE);
        }
        return indentedObjects;
    }

    public static String formatLogMessage(String message, Object ... arguments) {
        StringBuilder logMessage = new StringBuilder();
        StringBuilder[] formattedArguments = StringFormatter.indentAndToString(arguments);
        String[] messageParts = message.split("\\{}");
        for (int messagePartIndex = 0; messagePartIndex < messageParts.length; ++messagePartIndex) {
            logMessage.append(messageParts[messagePartIndex]);
            if (formattedArguments.length > 0 && formattedArguments.length > messagePartIndex) {
                logMessage.append((CharSequence)formattedArguments[messagePartIndex]);
            }
            if (messagePartIndex >= messageParts.length - 1) continue;
            logMessage.append(Character.NEW_LINE);
            if (messageParts[messagePartIndex + 1].startsWith(" ")) continue;
            logMessage.append(" ");
        }
        return logMessage.toString();
    }

    public static String formatLogMessage(String[] messageParts, Object ... arguments) {
        StringBuilder logMessage = new StringBuilder();
        StringBuilder[] formattedArguments = StringFormatter.indentAndToString(arguments);
        for (int messagePartIndex = 0; messagePartIndex < messageParts.length; ++messagePartIndex) {
            logMessage.append(messageParts[messagePartIndex]);
            if (formattedArguments.length <= 0 || formattedArguments.length <= messagePartIndex) continue;
            logMessage.append((CharSequence)formattedArguments[messagePartIndex]);
        }
        return logMessage.toString();
    }
}

