/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mock;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.callback.WebSocketClientRegistry;
import org.mockserver.character.Character;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.log.MockServerEventLog;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mock.Expectation;
import org.mockserver.mock.MockServerMatcher;
import org.mockserver.model.Action;
import org.mockserver.model.ClearType;
import org.mockserver.model.Format;
import org.mockserver.model.HttpError;
import org.mockserver.model.HttpObjectCallback;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.LogEventRequestAndResponse;
import org.mockserver.model.MediaType;
import org.mockserver.model.RetrieveType;
import org.mockserver.persistence.ExpectationFileSystemPersistence;
import org.mockserver.persistence.ExpectationFileWatcher;
import org.mockserver.responsewriter.ResponseWriter;
import org.mockserver.scheduler.Scheduler;
import org.mockserver.serialization.ExpectationSerializer;
import org.mockserver.serialization.HttpRequestSerializer;
import org.mockserver.serialization.LogEntrySerializer;
import org.mockserver.serialization.LogEventRequestAndResponseSerializer;
import org.mockserver.serialization.VerificationSequenceSerializer;
import org.mockserver.serialization.VerificationSerializer;
import org.mockserver.serialization.java.ExpectationToJavaSerializer;
import org.mockserver.serialization.java.HttpRequestToJavaSerializer;
import org.mockserver.server.initialize.ExpectationInitializerLoader;
import org.mockserver.verify.Verification;
import org.mockserver.verify.VerificationSequence;
import org.slf4j.event.Level;

public class HttpStateHandler {
    public static final String LOG_SEPARATOR = Character.NEW_LINE + "------------------------------------" + Character.NEW_LINE;
    public static final String PATH_PREFIX = "/mockserver";
    private final String uniqueLoopPreventionHeaderValue = "MockServer_" + UUID.randomUUID().toString();
    private final MockServerEventLog mockServerLog;
    private final Scheduler scheduler;
    private final ExpectationFileSystemPersistence expectationFileSystemPersistence;
    private final ExpectationFileWatcher expectationFileWatcher;
    private MockServerMatcher mockServerMatcher;
    private final MockServerLogger mockServerLogger;
    private WebSocketClientRegistry webSocketClientRegistry;
    private HttpRequestSerializer httpRequestSerializer;
    private LogEventRequestAndResponseSerializer httpRequestResponseSerializer;
    private ExpectationSerializer expectationSerializer;
    private HttpRequestToJavaSerializer httpRequestToJavaSerializer;
    private ExpectationToJavaSerializer expectationToJavaSerializer;
    private VerificationSerializer verificationSerializer;
    private VerificationSequenceSerializer verificationSequenceSerializer;
    private LogEntrySerializer logEntrySerializer;

    public HttpStateHandler(MockServerLogger mockServerLogger, Scheduler scheduler) {
        this.mockServerLogger = mockServerLogger.setHttpStateHandler(this);
        this.scheduler = scheduler;
        this.webSocketClientRegistry = new WebSocketClientRegistry(mockServerLogger);
        this.mockServerLog = new MockServerEventLog(mockServerLogger, scheduler, true);
        this.mockServerMatcher = new MockServerMatcher(mockServerLogger, scheduler, this.webSocketClientRegistry);
        this.httpRequestSerializer = new HttpRequestSerializer(mockServerLogger);
        this.httpRequestResponseSerializer = new LogEventRequestAndResponseSerializer(mockServerLogger);
        this.expectationSerializer = new ExpectationSerializer(mockServerLogger);
        this.httpRequestToJavaSerializer = new HttpRequestToJavaSerializer();
        this.expectationToJavaSerializer = new ExpectationToJavaSerializer();
        this.verificationSerializer = new VerificationSerializer(mockServerLogger);
        this.verificationSequenceSerializer = new VerificationSequenceSerializer(mockServerLogger);
        this.logEntrySerializer = new LogEntrySerializer(mockServerLogger);
        this.expectationFileSystemPersistence = new ExpectationFileSystemPersistence(mockServerLogger, this.mockServerMatcher);
        this.expectationFileWatcher = new ExpectationFileWatcher(mockServerLogger, this.mockServerMatcher);
        new ExpectationInitializerLoader(mockServerLogger, this.mockServerMatcher);
    }

    public MockServerLogger getMockServerLogger() {
        return this.mockServerLogger;
    }

    public void clear(HttpRequest request) {
        HttpRequest requestMatcher = null;
        if (StringUtils.isNotBlank((CharSequence)request.getBodyAsString())) {
            requestMatcher = this.httpRequestSerializer.deserialize(request.getBodyAsString());
        }
        try {
            ClearType retrieveType = ClearType.valueOf((String)StringUtils.defaultIfEmpty((CharSequence)request.getFirstQueryStringParameter("type").toUpperCase(), (CharSequence)"ALL"));
            switch (retrieveType) {
                case LOG: {
                    this.mockServerLog.clear(requestMatcher);
                    this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.CLEARED).setLogLevel(Level.INFO).setHttpRequest(requestMatcher).setMessageFormat("clearing logs that match:{}").setArguments(requestMatcher == null ? "{}" : requestMatcher));
                    break;
                }
                case EXPECTATIONS: {
                    this.mockServerMatcher.clear(requestMatcher);
                    this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.CLEARED).setLogLevel(Level.INFO).setHttpRequest(requestMatcher).setMessageFormat("clearing expectations that match:{}").setArguments(requestMatcher == null ? "{}" : requestMatcher));
                    break;
                }
                case ALL: {
                    this.mockServerLog.clear(requestMatcher);
                    this.mockServerMatcher.clear(requestMatcher);
                    this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.CLEARED).setLogLevel(Level.INFO).setHttpRequest(requestMatcher).setMessageFormat("clearing expectations and logs that match:{}").setArguments(requestMatcher == null ? "{}" : requestMatcher));
                }
            }
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("\"" + request.getFirstQueryStringParameter("type") + "\" is not a valid value for \"type\" parameter, only the following values are supported " + Arrays.stream(ClearType.values()).map(input -> input.name().toLowerCase()).collect(Collectors.toList()));
        }
    }

    public void reset() {
        this.mockServerMatcher.reset();
        this.mockServerLog.reset();
        this.webSocketClientRegistry.reset();
        this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.CLEARED).setLogLevel(Level.INFO).setHttpRequest(HttpRequest.request()).setMessageFormat("resetting all expectations and request logs"));
    }

    public void add(Expectation ... expectations) {
        for (Expectation expectation : expectations) {
            String hostHeader;
            if (expectation.getHttpRequest() != null && StringUtils.isNotBlank((CharSequence)(hostHeader = expectation.getHttpRequest().getFirstHeader(HttpHeaderNames.HOST.toString())))) {
                this.scheduler.submit(() -> ConfigurationProperties.addSubjectAlternativeName(hostHeader));
            }
            this.mockServerMatcher.add(expectation);
        }
    }

    public Expectation firstMatchingExpectation(HttpRequest request) {
        if (this.mockServerMatcher.isEmpty()) {
            return null;
        }
        return this.mockServerMatcher.firstMatchingExpectation(request);
    }

    public void postProcess(Expectation expectation) {
        this.mockServerMatcher.postProcess(expectation);
    }

    public void log(LogEntry logEntry) {
        if (this.mockServerLog != null) {
            this.mockServerLog.add(logEntry);
        }
    }

    public HttpResponse retrieve(HttpRequest request) {
        CompletableFuture<HttpResponse> httpResponseFuture = new CompletableFuture<HttpResponse>();
        HttpResponse response = HttpResponse.response().withStatusCode(200);
        if (request != null) {
            try {
                HttpRequest httpRequest = StringUtils.isNotBlank((CharSequence)request.getBodyAsString()) ? this.httpRequestSerializer.deserialize(request.getBodyAsString()) : null;
                Format format = Format.valueOf((String)StringUtils.defaultIfEmpty((CharSequence)request.getFirstQueryStringParameter("format").toUpperCase(), (CharSequence)"JSON"));
                RetrieveType retrieveType = RetrieveType.valueOf((String)StringUtils.defaultIfEmpty((CharSequence)request.getFirstQueryStringParameter("type").toUpperCase(), (CharSequence)"REQUESTS"));
                switch (retrieveType) {
                    case LOGS: {
                        Object[] arguments = new Object[]{httpRequest == null ? HttpRequest.request() : httpRequest};
                        this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.RETRIEVED).setLogLevel(Level.INFO).setHttpRequest(httpRequest).setMessageFormat("retrieving logs that match:{}").setArguments(arguments));
                        this.mockServerLog.retrieveMessageLogEntries(httpRequest, logEntries -> {
                            StringBuilder stringBuffer = new StringBuilder();
                            for (int i = 0; i < logEntries.size(); ++i) {
                                LogEntry messageLogEntry = (LogEntry)logEntries.get(i);
                                stringBuffer.append(messageLogEntry.getTimestamp()).append(" - ").append(messageLogEntry.getMessage());
                                if (i >= logEntries.size() - 1) continue;
                                stringBuffer.append(LOG_SEPARATOR);
                            }
                            stringBuffer.append(Character.NEW_LINE);
                            response.withBody(stringBuffer.toString(), MediaType.PLAIN_TEXT_UTF_8);
                            httpResponseFuture.complete(response);
                        });
                        break;
                    }
                    case REQUESTS: {
                        Object[] arguments = new Object[]{httpRequest == null ? HttpRequest.request() : httpRequest};
                        this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.RETRIEVED).setLogLevel(Level.INFO).setHttpRequest(httpRequest).setMessageFormat("retrieving requests in " + format.name().toLowerCase() + " that match:{}").setArguments(arguments));
                        switch (format) {
                            case JAVA: {
                                this.mockServerLog.retrieveRequests(httpRequest, requests -> {
                                    response.withBody(this.httpRequestToJavaSerializer.serialize((List<HttpRequest>)requests), MediaType.create("application", "java").withCharset(StandardCharsets.UTF_8));
                                    httpResponseFuture.complete(response);
                                });
                                break;
                            }
                            case JSON: {
                                this.mockServerLog.retrieveRequests(httpRequest, requests -> {
                                    response.withBody(this.httpRequestSerializer.serialize((List<HttpRequest>)requests), MediaType.JSON_UTF_8);
                                    httpResponseFuture.complete(response);
                                });
                                break;
                            }
                            case LOG_ENTRIES: {
                                this.mockServerLog.retrieveRequestLogEntries(httpRequest, logEntries -> {
                                    response.withBody(this.logEntrySerializer.serialize((List<LogEntry>)logEntries), MediaType.JSON_UTF_8);
                                    httpResponseFuture.complete(response);
                                });
                            }
                        }
                        break;
                    }
                    case REQUEST_RESPONSES: {
                        Object[] arguments = new Object[]{httpRequest == null ? HttpRequest.request() : httpRequest};
                        this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.RETRIEVED).setLogLevel(Level.INFO).setHttpRequest(httpRequest).setMessageFormat("retrieving requests and responses in " + format.name().toLowerCase() + " that match:{}").setArguments(arguments));
                        switch (format) {
                            case JAVA: {
                                response.withBody("JAVA not supported for REQUEST_RESPONSES", MediaType.create("text", "plain").withCharset(StandardCharsets.UTF_8));
                                httpResponseFuture.complete(response);
                                break;
                            }
                            case JSON: {
                                this.mockServerLog.retrieveRequestResponses(httpRequest, httpRequestAndHttpResponses -> {
                                    response.withBody(this.httpRequestResponseSerializer.serialize((List<LogEventRequestAndResponse>)httpRequestAndHttpResponses), MediaType.JSON_UTF_8);
                                    httpResponseFuture.complete(response);
                                });
                                break;
                            }
                            case LOG_ENTRIES: {
                                this.mockServerLog.retrieveRequestResponseMessageLogEntries(httpRequest, logEntries -> {
                                    response.withBody(this.logEntrySerializer.serialize((List<LogEntry>)logEntries), MediaType.JSON_UTF_8);
                                    httpResponseFuture.complete(response);
                                });
                            }
                        }
                        break;
                    }
                    case RECORDED_EXPECTATIONS: {
                        Object[] arguments = new Object[]{httpRequest == null ? HttpRequest.request() : httpRequest};
                        this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.RETRIEVED).setLogLevel(Level.INFO).setHttpRequest(httpRequest).setMessageFormat("retrieving recorded expectations in " + format.name().toLowerCase() + " that match:{}").setArguments(arguments));
                        switch (format) {
                            case JAVA: {
                                this.mockServerLog.retrieveRecordedExpectations(httpRequest, requests -> {
                                    response.withBody(this.expectationToJavaSerializer.serialize((List<Expectation>)requests), MediaType.create("application", "java").withCharset(StandardCharsets.UTF_8));
                                    httpResponseFuture.complete(response);
                                });
                                break;
                            }
                            case JSON: {
                                this.mockServerLog.retrieveRecordedExpectations(httpRequest, requests -> {
                                    response.withBody(this.expectationSerializer.serialize((List<Expectation>)requests), MediaType.JSON_UTF_8);
                                    httpResponseFuture.complete(response);
                                });
                                break;
                            }
                            case LOG_ENTRIES: {
                                this.mockServerLog.retrieveRecordedExpectationLogEntries(httpRequest, logEntries -> {
                                    response.withBody(this.logEntrySerializer.serialize((List<LogEntry>)logEntries), MediaType.JSON_UTF_8);
                                    httpResponseFuture.complete(response);
                                });
                            }
                        }
                        break;
                    }
                    case ACTIVE_EXPECTATIONS: {
                        this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.RETRIEVED).setLogLevel(Level.INFO).setHttpRequest(httpRequest).setMessageFormat("retrieving active expectations in " + format.name().toLowerCase() + " that match:{}").setArguments(httpRequest == null ? HttpRequest.request() : httpRequest));
                        List<Expectation> expectations = this.mockServerMatcher.retrieveActiveExpectations(httpRequest);
                        switch (format) {
                            case JAVA: {
                                response.withBody(this.expectationToJavaSerializer.serialize(expectations), MediaType.create("application", "java").withCharset(StandardCharsets.UTF_8));
                                break;
                            }
                            case JSON: {
                                response.withBody(this.expectationSerializer.serialize(expectations), MediaType.JSON_UTF_8);
                                break;
                            }
                            case LOG_ENTRIES: {
                                response.withBody("LOG_ENTRIES not supported for ACTIVE_EXPECTATIONS", MediaType.create("text", "plain").withCharset(StandardCharsets.UTF_8));
                            }
                        }
                        httpResponseFuture.complete(response);
                        break;
                    }
                }
                try {
                    return (HttpResponse)httpResponseFuture.get(ConfigurationProperties.maxFutureTimeout(), TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException | ExecutionException | TimeoutException e) {
                    throw new RuntimeException("Exception retrieving state for " + request, e);
                }
            }
            catch (IllegalArgumentException iae) {
                if (iae.getMessage().contains(RetrieveType.class.getSimpleName())) {
                    throw new IllegalArgumentException("\"" + request.getFirstQueryStringParameter("type") + "\" is not a valid value for \"type\" parameter, only the following values are supported " + Arrays.stream(RetrieveType.values()).map(input -> input.name().toLowerCase()).collect(Collectors.toList()));
                }
                throw new IllegalArgumentException("\"" + request.getFirstQueryStringParameter("format") + "\" is not a valid value for \"format\" parameter, only the following values are supported " + Arrays.stream(Format.values()).map(input -> input.name().toLowerCase()).collect(Collectors.toList()));
            }
        }
        return HttpResponse.response().withStatusCode(200);
    }

    public Future<String> verify(Verification verification) {
        CompletableFuture<String> result = new CompletableFuture<String>();
        this.verify(verification, result::complete);
        return result;
    }

    public void verify(Verification verification, Consumer<String> resultConsumer) {
        this.mockServerLog.verify(verification, resultConsumer);
    }

    public Future<String> verify(VerificationSequence verification) {
        CompletableFuture<String> result = new CompletableFuture<String>();
        this.verify(verification, result::complete);
        return result;
    }

    public void verify(VerificationSequence verification, Consumer<String> resultConsumer) {
        this.mockServerLog.verify(verification, resultConsumer);
    }

    public boolean handle(HttpRequest request, ResponseWriter responseWriter, boolean warDeployment) {
        this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setHttpRequest(request).setMessageFormat("received request:{}").setArguments(request));
        if (request.matches("PUT")) {
            CompletableFuture<Boolean> canHandle = new CompletableFuture<Boolean>();
            if (request.matches("PUT", "/mockserver/expectation", "/expectation")) {
                for (Expectation expectation : this.expectationSerializer.deserializeArray(request.getBodyAsString(), false)) {
                    if (warDeployment && !this.validateSupportedFeatures(expectation, request, responseWriter)) continue;
                    this.add(expectation);
                }
                responseWriter.writeResponse(request, HttpResponseStatus.CREATED);
                canHandle.complete(true);
            } else if (request.matches("PUT", "/mockserver/clear", "/clear")) {
                this.clear(request);
                responseWriter.writeResponse(request, HttpResponseStatus.OK);
                canHandle.complete(true);
            } else if (request.matches("PUT", "/mockserver/reset", "/reset")) {
                this.reset();
                responseWriter.writeResponse(request, HttpResponseStatus.OK);
                canHandle.complete(true);
            } else if (request.matches("PUT", "/mockserver/retrieve", "/retrieve")) {
                responseWriter.writeResponse(request, this.retrieve(request), true);
                canHandle.complete(true);
            } else if (request.matches("PUT", "/mockserver/verify", "/verify")) {
                Verification verification = this.verificationSerializer.deserialize(request.getBodyAsString());
                this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.VERIFICATION).setLogLevel(Level.INFO).setHttpRequest(verification.getHttpRequest()).setMessageFormat("verifying requests that match:{}").setArguments(verification));
                this.verify(verification, (String result) -> {
                    if (StringUtils.isEmpty((CharSequence)result)) {
                        responseWriter.writeResponse(request, HttpResponseStatus.ACCEPTED);
                    } else {
                        responseWriter.writeResponse(request, HttpResponseStatus.NOT_ACCEPTABLE, (String)result, MediaType.create("text", "plain").toString());
                    }
                    canHandle.complete(true);
                });
            } else if (request.matches("PUT", "/mockserver/verifySequence", "/verifySequence")) {
                VerificationSequence verificationSequence = this.verificationSequenceSerializer.deserialize(request.getBodyAsString());
                this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.VERIFICATION).setLogLevel(Level.INFO).setHttpRequests(verificationSequence.getHttpRequests().toArray(new HttpRequest[0])).setMessageFormat("verifying sequence that match:{}").setArguments(verificationSequence));
                this.verify(verificationSequence, (String result) -> {
                    if (StringUtils.isEmpty((CharSequence)result)) {
                        responseWriter.writeResponse(request, HttpResponseStatus.ACCEPTED);
                    } else {
                        responseWriter.writeResponse(request, HttpResponseStatus.NOT_ACCEPTABLE, (String)result, MediaType.create("text", "plain").toString());
                    }
                    canHandle.complete(true);
                });
            } else {
                canHandle.complete(false);
            }
            try {
                return (Boolean)canHandle.get(ConfigurationProperties.maxFutureTimeout(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException ignore) {
                return false;
            }
        }
        return false;
    }

    private boolean validateSupportedFeatures(Expectation expectation, HttpRequest request, ResponseWriter responseWriter) {
        boolean valid = true;
        Action action = expectation.getAction();
        String NOT_SUPPORTED_MESSAGE = " is not supported by MockServer deployed as a WAR due to limitations in the JEE specification; use mockserver-netty to enable these features";
        if (action instanceof HttpResponse && ((HttpResponse)action).getConnectionOptions() != null) {
            valid = false;
            responseWriter.writeResponse(request, HttpResponse.response("ConnectionOptions" + NOT_SUPPORTED_MESSAGE), true);
        } else if (action instanceof HttpObjectCallback) {
            valid = false;
            responseWriter.writeResponse(request, HttpResponse.response("HttpObjectCallback" + NOT_SUPPORTED_MESSAGE), true);
        } else if (action instanceof HttpError) {
            valid = false;
            responseWriter.writeResponse(request, HttpResponse.response("HttpError" + NOT_SUPPORTED_MESSAGE), true);
        }
        return valid;
    }

    public WebSocketClientRegistry getWebSocketClientRegistry() {
        return this.webSocketClientRegistry;
    }

    public MockServerMatcher getMockServerMatcher() {
        return this.mockServerMatcher;
    }

    public MockServerEventLog getMockServerLog() {
        return this.mockServerLog;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public String getUniqueLoopPreventionHeaderName() {
        return "x-forwarded-by";
    }

    public String getUniqueLoopPreventionHeaderValue() {
        return this.uniqueLoopPreventionHeaderValue;
    }

    public void stop() {
        this.expectationFileSystemPersistence.stop();
        this.expectationFileWatcher.stop();
        this.getMockServerLog().stop();
    }
}

