/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.proxy.error;

import io.netty.util.internal.PlatformDependent;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SocketChannel;
import java.util.regex.Pattern;

public class Logging {
    private static final Pattern IGNORABLE_CLASS_IN_STACK = Pattern.compile("^.*(?:Socket|Datagram|Sctp|Udt)Channel.*$");
    private static final Pattern IGNORABLE_ERROR_MESSAGE = Pattern.compile("^.*(?:connection.*(?:reset|closed|abort|broken)|broken.*pipe).*$", 2);

    public static boolean shouldIgnoreException(Throwable cause) {
        StackTraceElement[] elements;
        String message = String.valueOf(cause.getMessage()).toLowerCase();
        if (IGNORABLE_ERROR_MESSAGE.matcher(message).matches()) {
            return true;
        }
        for (StackTraceElement element : elements = cause.getStackTrace()) {
            String classname = element.getClassName();
            String methodname = element.getMethodName();
            if (classname.startsWith("io.netty.") || !"read".equals(methodname)) continue;
            if (IGNORABLE_CLASS_IN_STACK.matcher(classname).matches()) {
                return true;
            }
            try {
                Class<?> clazz = PlatformDependent.getClassLoader(Logging.class).loadClass(classname);
                if (SocketChannel.class.isAssignableFrom(clazz) || DatagramChannel.class.isAssignableFrom(clazz)) {
                    return true;
                }
                if (PlatformDependent.javaVersion() < 7 || !"com.sun.nio.sctp.SctpChannel".equals(clazz.getSuperclass().getName())) continue;
                return true;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        return false;
    }
}

