/*
 * Decompiled with CFR 0.152.
 */
package org.mockftpserver.fake.filesystem;

import org.mockftpserver.core.util.Assert;
import org.mockftpserver.fake.filesystem.AbstractFakeFileSystem;
import org.mockftpserver.fake.filesystem.WindowsDirectoryListingFormatter;

public class WindowsFakeFileSystem
extends AbstractFakeFileSystem {
    public static final char SEPARATOR = '\\';
    private static final String VALID_PATTERN = "\\p{Alpha}\\:(\\\\|(\\\\[^\\\\\\:\\*\\?\\<\\>\\|\\\"]+)+)";
    private static final String LAN_PREFIX = "\\\\";

    public WindowsFakeFileSystem() {
        this.setDirectoryListingFormatter(new WindowsDirectoryListingFormatter());
    }

    protected String getFileSystemEntryKey(String path) {
        return this.normalize(path).toLowerCase();
    }

    protected char getSeparatorChar() {
        return '\\';
    }

    protected boolean isValidName(String path) {
        Assert.notNull(path, "path");
        String standardized = path.replace('/', '\\');
        return standardized.matches(VALID_PATTERN) || standardized.startsWith(LAN_PREFIX);
    }

    protected boolean isSeparator(char c) {
        return c == '\\' || c == '/';
    }

    protected boolean isRoot(String pathComponent) {
        return pathComponent.indexOf(":") != -1;
    }
}

