/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.configuration;

import java.lang.annotation.Annotation;
import org.mockito.DoNotMock;
import org.mockito.plugins.DoNotMockEnforcer;

public class DefaultDoNotMockEnforcer
implements DoNotMockEnforcer {
    @Override
    public String checkTypeForDoNotMockViolation(Class<?> type) {
        for (Annotation annotation : type.getAnnotations()) {
            if (!annotation.annotationType().getName().endsWith("org.mockito.DoNotMock")) continue;
            String exceptionMessage = type + " is annotated with @org.mockito.DoNoMock and can't be mocked.";
            if (DoNotMock.class.equals(annotation.annotationType())) {
                exceptionMessage = exceptionMessage + " " + type.getAnnotation(DoNotMock.class).reason();
            }
            return exceptionMessage;
        }
        return null;
    }
}

