/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.creation;

import java.util.Arrays;

public final class SuspendMethod {
    private static final String KOTLIN_EXPERIMENTAL_CONTINUATION = "kotlin.coroutines.experimental.Continuation";
    private static final String KOTLIN_CONTINUATION = "kotlin.coroutines.Continuation";

    public static Class<?>[] trimSuspendParameterTypes(Class<?>[] parameterTypes) {
        int n = parameterTypes.length;
        if (n > 0 && SuspendMethod.isContinuationType(parameterTypes[n - 1])) {
            return Arrays.copyOf(parameterTypes, n - 1);
        }
        return parameterTypes;
    }

    private static boolean isContinuationType(Class<?> parameterType) {
        String name = parameterType.getName();
        return name.equals(KOTLIN_CONTINUATION) || name.equals(KOTLIN_EXPERIMENTAL_CONTINUATION);
    }

    private SuspendMethod() {
    }
}

