/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.debugging;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.exceptions.stacktrace.StackTraceCleaner;
import org.mockito.internal.configuration.plugins.Plugins;
import org.mockito.internal.exceptions.stacktrace.DefaultStackTraceCleaner;
import org.mockito.invocation.Location;

class LocationImpl
implements Location,
Serializable {
    private static final long serialVersionUID = 2954388321980069195L;
    private static final String UNEXPECTED_ERROR_SUFFIX = "\nThis is unexpected and is likely due to a change in either Java's StackWalker or Reflection APIs.\nIt's worth trying to upgrade to a newer version of Mockito, or otherwise to file a bug report.";
    private static final int BUFFER_SIZE = 16;
    private static final StackWalker STACK_WALKER = LocationImpl.stackWalker();
    private static final String PREFIX = "-> at ";
    private static final StackTraceCleaner CLEANER = Plugins.getStackTraceCleanerProvider().getStackTraceCleaner(new DefaultStackTraceCleaner());
    private static final Function<StackWalker.StackFrame, StackTraceCleaner.StackFrameMetadata> toStackFrameMetadata = x$0 -> new MetadataShim((StackWalker.StackFrame)x$0);
    private static final Predicate<StackTraceCleaner.StackFrameMetadata> cleanerIsIn = CLEANER::isIn;
    private static final int FRAMES_TO_SKIP = LocationImpl.framesToSkip();
    private final StackTraceCleaner.StackFrameMetadata sfm;
    private volatile String stackTraceLine;

    LocationImpl(boolean isInline) {
        this.sfm = LocationImpl.getStackFrame(isInline);
    }

    @Override
    public String getSourceFile() {
        return this.sfm.getFileName();
    }

    @Override
    public String toString() {
        return this.stackTraceLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String stackTraceLine() {
        if (this.stackTraceLine == null) {
            LocationImpl locationImpl = this;
            synchronized (locationImpl) {
                if (this.stackTraceLine == null) {
                    this.stackTraceLine = PREFIX + this.sfm.toString();
                }
            }
        }
        return this.stackTraceLine;
    }

    private static StackTraceCleaner.StackFrameMetadata getStackFrame(boolean isInline) {
        return LocationImpl.stackWalk(stream -> stream.map(toStackFrameMetadata).skip(FRAMES_TO_SKIP).filter(cleanerIsIn).skip(isInline ? 1L : 0L).findFirst().orElseThrow(() -> new MockitoException(LocationImpl.noStackTraceFailureMessage())));
    }

    private static boolean usingDefaultStackTraceCleaner() {
        return CLEANER instanceof DefaultStackTraceCleaner;
    }

    private static String noStackTraceFailureMessage() {
        if (LocationImpl.usingDefaultStackTraceCleaner()) {
            return "Mockito could not find the first non-Mockito stack frame.\nThis is unexpected and is likely due to a change in either Java's StackWalker or Reflection APIs.\nIt's worth trying to upgrade to a newer version of Mockito, or otherwise to file a bug report.";
        }
        String cleanerType = CLEANER.getClass().getName();
        String fmt = "Mockito could not find the first non-Mockito stack frame. A custom stack frame cleaner \n(type %s) is in use and this has mostly likely filtered out all the relevant stack frames.";
        return String.format(fmt, cleanerType);
    }

    private static int framesToSkip() {
        return LocationImpl.stackWalk(stream -> {
            List metadata = stream.map(toStackFrameMetadata).map(StackTraceCleaner.StackFrameMetadata::getClassName).collect(Collectors.toList());
            return metadata.indexOf(LocationImpl.class.getName());
        });
    }

    private static <T> T stackWalk(Function<Stream<StackWalker.StackFrame>, T> function) {
        return STACK_WALKER.walk(function);
    }

    private static StackWalker stackWalker() {
        return StackWalker.getInstance(Collections.singleton(StackWalker.Option.SHOW_REFLECT_FRAMES), 16);
    }

    private static final class MetadataShim
    implements StackTraceCleaner.StackFrameMetadata,
    Serializable {
        private static final long serialVersionUID = 8491903719411428648L;
        private final StackWalker.StackFrame stackFrame;

        private MetadataShim(StackWalker.StackFrame stackFrame) {
            this.stackFrame = stackFrame;
        }

        @Override
        public String getClassName() {
            return this.stackFrame.getClassName();
        }

        @Override
        public String getMethodName() {
            return this.stackFrame.getMethodName();
        }

        @Override
        public String getFileName() {
            return this.stackFrame.getFileName();
        }

        @Override
        public int getLineNumber() {
            return this.stackFrame.getLineNumber();
        }

        public String toString() {
            return this.stackFrame.toString();
        }

        private Object writeReplace() {
            return new SerializableShim(this.stackFrame.toStackTraceElement());
        }
    }

    private static final class SerializableShim
    implements StackTraceCleaner.StackFrameMetadata,
    Serializable {
        private static final long serialVersionUID = 7908320459080898690L;
        private final StackTraceElement ste;

        private SerializableShim(StackTraceElement ste) {
            this.ste = ste;
        }

        @Override
        public String getClassName() {
            return this.ste.getClassName();
        }

        @Override
        public String getMethodName() {
            return this.ste.getMethodName();
        }

        @Override
        public String getFileName() {
            return this.ste.getFileName();
        }

        @Override
        public int getLineNumber() {
            return this.ste.getLineNumber();
        }
    }
}

