/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.creation.proxy;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.mockito.internal.SuppressSignatureCheck;
import org.mockito.internal.creation.proxy.ProxyRealMethod;
import org.mockito.internal.invocation.RealMethod;

@SuppressSignatureCheck
class MethodHandleProxy
implements ProxyRealMethod {
    private final MethodHandles.Lookup lookup = MethodHandles.lookup();

    MethodHandleProxy() throws Throwable {
    }

    @Override
    public RealMethod resolve(Object proxy, Method method, Object[] args) {
        try {
            return new MethodHandleRealMethod(this.lookup.findSpecial(method.getDeclaringClass(), method.getName(), MethodType.methodType(method.getReturnType(), method.getParameterTypes()), method.getDeclaringClass()).bindTo(proxy), args);
        }
        catch (Throwable ignored) {
            return RealMethod.IsIllegal.INSTANCE;
        }
    }

    @SuppressSignatureCheck
    private static class MethodHandleRealMethod
    implements RealMethod,
    Serializable {
        private static final long serialVersionUID = -1L;
        private final MethodHandle handle;
        private final Object[] args;

        private MethodHandleRealMethod(MethodHandle handle, Object[] args) {
            this.handle = handle;
            this.args = args;
        }

        @Override
        public boolean isInvokable() {
            return true;
        }

        @Override
        public Object invoke() throws Throwable {
            return this.handle.invokeWithArguments(this.args);
        }
    }

    @SuppressSignatureCheck
    static class LegacyVersion
    implements ProxyRealMethod {
        private final Constructor<MethodHandles.Lookup> constructor;

        LegacyVersion() throws Throwable {
            try {
                Class.forName("java.lang.Module");
                throw new RuntimeException("Must not be used when modules are available");
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class);
                this.constructor.setAccessible(true);
                return;
            }
        }

        @Override
        public RealMethod resolve(Object proxy, Method method, Object[] args) {
            try {
                return new MethodHandleRealMethod(this.constructor.newInstance(method.getDeclaringClass()).in(method.getDeclaringClass()).unreflectSpecial(method, method.getDeclaringClass()).bindTo(proxy), args);
            }
            catch (Throwable ignored) {
                return RealMethod.IsIllegal.INSTANCE;
            }
        }
    }
}

