/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.convention;

import org.modelmapper.internal.util.Strings;
import org.modelmapper.spi.NameTransformer;
import org.modelmapper.spi.NameableType;

public class NameTransformers {
    public static final NameTransformer JAVABEANS_ACCESSOR = new NameTransformer(){

        @Override
        public String transform(String name, NameableType nameableType) {
            if (NameableType.METHOD.equals((Object)nameableType)) {
                if (name.startsWith("get") && name.length() > 3) {
                    return Strings.decapitalize(name.substring(3));
                }
                if (name.startsWith("is") && name.length() > 2) {
                    return Strings.decapitalize(name.substring(2));
                }
            }
            return name;
        }

        public String toString() {
            return "Javabeans Accessor";
        }
    };
    public static final NameTransformer JAVABEANS_MUTATOR = new NameTransformer(){

        @Override
        public String transform(String name, NameableType nameableType) {
            if (NameableType.METHOD.equals((Object)nameableType) && name.startsWith("set") && name.length() > 3) {
                return Strings.decapitalize(name.substring(3));
            }
            return name;
        }

        public String toString() {
            return "Javabeans Mutator";
        }
    };

    public static NameTransformer builder() {
        return NameTransformers.builder("");
    }

    public static NameTransformer builder(String prefix) {
        return new BuilderNameTransformer(prefix);
    }

    private static class BuilderNameTransformer
    implements NameTransformer {
        private String prefix;

        private BuilderNameTransformer(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public String transform(String name, NameableType nameableType) {
            if (this.prefix.isEmpty()) {
                return name;
            }
            if (name.startsWith(this.prefix)) {
                return Strings.decapitalize(name.substring(this.prefix.length()));
            }
            return name;
        }

        public String toString() {
            return "Builder(prefix=" + this.prefix + ")";
        }
    }
}

