/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.internal;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.modelmapper.ModelMapper;

public class BridgeClassLoaderFactory {
    private static final Map<ClassLoader, WeakReference<BridgeClassLoader>> CACHE = new WeakHashMap<ClassLoader, WeakReference<BridgeClassLoader>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ClassLoader getClassLoader(Class<?> appType) {
        Set<Class<?>> allExtendedOrImplementedTypesRecursively = BridgeClassLoaderFactory.getAllExtendedOrImplementedTypesRecursively(appType);
        Set<ClassLoader> allClassLoadersInTheTypeHierarchy = BridgeClassLoaderFactory.getAllClassLoadersInTheTypeHierarchy(allExtendedOrImplementedTypesRecursively);
        Class<BridgeClassLoaderFactory> clazz = BridgeClassLoaderFactory.class;
        synchronized (BridgeClassLoaderFactory.class) {
            BridgeClassLoader bridgeClassLoader = null;
            WeakReference<BridgeClassLoader> bridgeClassLoaderRef = CACHE.get(appType.getClassLoader());
            if (bridgeClassLoaderRef != null) {
                bridgeClassLoader = (BridgeClassLoader)bridgeClassLoaderRef.get();
            }
            if (bridgeClassLoader == null) {
                bridgeClassLoader = new BridgeClassLoader(appType.getClassLoader());
                CACHE.put(appType.getClassLoader(), new WeakReference<BridgeClassLoader>(bridgeClassLoader));
            }
            bridgeClassLoader.addAdditionalClassLoaders(allClassLoadersInTheTypeHierarchy);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return bridgeClassLoader;
        }
    }

    private static Set<ClassLoader> getAllClassLoadersInTheTypeHierarchy(Set<Class<?>> allExtendedOrImplementedTypesRecursively) {
        HashSet<ClassLoader> result = new HashSet<ClassLoader>();
        for (Class<?> clazz : allExtendedOrImplementedTypesRecursively) {
            if (clazz.getClassLoader() == null) continue;
            result.add(clazz.getClassLoader());
        }
        return result;
    }

    private static Set<Class<?>> getAllExtendedOrImplementedTypesRecursively(Class<?> clazzArg) {
        Class<?> superClass;
        Class<?> clazz = clazzArg;
        ArrayList res = new ArrayList();
        do {
            res.add(clazz);
            Class<?>[] interfaces = clazz.getInterfaces();
            if (interfaces.length <= 0) continue;
            res.addAll(Arrays.asList(interfaces));
            for (Class<?> interfaze : interfaces) {
                res.addAll(BridgeClassLoaderFactory.getAllExtendedOrImplementedTypesRecursively(interfaze));
            }
        } while ((superClass = clazz.getSuperclass()) != null && !"java.lang.Object".equals((clazz = superClass).getCanonicalName()));
        return new HashSet(res);
    }

    private static final class BridgeClassLoader
    extends ClassLoader {
        private final ClassLoader internalClassSpace = ModelMapper.class.getClassLoader();
        private final Set<ClassLoader> additionalClassLoaders = Collections.newSetFromMap(new ConcurrentHashMap());

        BridgeClassLoader(ClassLoader primary) {
            super(primary);
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            if (name.startsWith("org.modelmapper.internal.cglib")) {
                return this.internalClassSpace.loadClass(name);
            }
            for (ClassLoader additionalClassLoader : this.additionalClassLoaders) {
                try {
                    return additionalClassLoader.loadClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            throw new ClassNotFoundException(name);
        }

        private void addAdditionalClassLoaders(Set<ClassLoader> additionalClassLoaders) {
            additionalClassLoaders.remove(this.getParent());
            this.additionalClassLoaders.addAll(additionalClassLoaders);
        }
    }
}

