/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink;

import com.mongodb.MongoNamespace;
import com.mongodb.kafka.connect.sink.RateLimitSettings;
import com.mongodb.kafka.connect.sink.cdc.CdcHandler;
import com.mongodb.kafka.connect.sink.processor.BlacklistKeyProjector;
import com.mongodb.kafka.connect.sink.processor.BlacklistValueProjector;
import com.mongodb.kafka.connect.sink.processor.PostProcessors;
import com.mongodb.kafka.connect.sink.processor.WhitelistKeyProjector;
import com.mongodb.kafka.connect.sink.processor.WhitelistValueProjector;
import com.mongodb.kafka.connect.sink.processor.field.projection.FieldProjector;
import com.mongodb.kafka.connect.sink.processor.id.strategy.FullKeyStrategy;
import com.mongodb.kafka.connect.sink.processor.id.strategy.IdStrategy;
import com.mongodb.kafka.connect.sink.processor.id.strategy.PartialKeyStrategy;
import com.mongodb.kafka.connect.sink.processor.id.strategy.PartialValueStrategy;
import com.mongodb.kafka.connect.sink.processor.id.strategy.ProvidedInKeyStrategy;
import com.mongodb.kafka.connect.sink.writemodel.strategy.DeleteOneDefaultStrategy;
import com.mongodb.kafka.connect.sink.writemodel.strategy.WriteModelStrategy;
import com.mongodb.kafka.connect.util.ClassHelper;
import com.mongodb.kafka.connect.util.ConfigHelper;
import com.mongodb.kafka.connect.util.ConnectConfigException;
import com.mongodb.kafka.connect.util.Validators;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigValue;

public class MongoSinkTopicConfig
extends AbstractConfig {
    private static final String TOPIC_CONFIG = "topic";
    private static final String TOPIC_OVERRIDE_PREFIX = "topic.override.";
    public static final String DATABASE_CONFIG = "database";
    private static final String DATABASE_DISPLAY = "The MongoDB database name.";
    private static final String DATABASE_DOC = "The database for the sink to write.";
    public static final String COLLECTION_CONFIG = "collection";
    private static final String COLLECTION_DISPLAY = "The default MongoDB collection name";
    private static final String COLLECTION_DOC = "Optional, single sink collection name to write to. If following multiple topics then this will be the default collection they are mapped to.";
    private static final String COLLECTION_DEFAULT = "";
    public static final String MAX_NUM_RETRIES_CONFIG = "max.num.retries";
    private static final String MAX_NUM_RETRIES_DISPLAY = "Max number of retries";
    private static final String MAX_NUM_RETRIES_DOC = "How often a retry should be done on write errors";
    private static final int MAX_NUM_RETRIES_DEFAULT = 3;
    public static final String RETRIES_DEFER_TIMEOUT_CONFIG = "retries.defer.timeout";
    private static final String RETRIES_DEFER_TIMEOUT_DISPLAY = "Retry defer timeout";
    private static final String RETRIES_DEFER_TIMEOUT_DOC = "How long in ms a retry should get deferred";
    private static final int RETRIES_DEFER_TIMEOUT_DEFAULT = 5000;
    public static final String DOCUMENT_ID_STRATEGY_CONFIG = "document.id.strategy";
    private static final String DOCUMENT_ID_STRATEGY_DISPLAY = "The document id strategy";
    private static final String DOCUMENT_ID_STRATEGY_DOC = "The IdStrategy class name to use for generating a unique document id (_id)";
    private static final String DOCUMENT_ID_STRATEGY_DEFAULT = "com.mongodb.kafka.connect.sink.processor.id.strategy.BsonOidStrategy";
    public static final String KEY_PROJECTION_TYPE_CONFIG = "key.projection.type";
    private static final String KEY_PROJECTION_TYPE_DISPLAY = "The key projection type";
    private static final String KEY_PROJECTION_TYPE_DOC = "The type of key projection to use";
    private static final String KEY_PROJECTION_TYPE_DEFAULT = "none";
    public static final String KEY_PROJECTION_LIST_CONFIG = "key.projection.list";
    private static final String KEY_PROJECTION_LIST_DISPLAY = "The key projection list";
    private static final String KEY_PROJECTION_LIST_DOC = "A comma separated list of field names for key projection";
    private static final String KEY_PROJECTION_LIST_DEFAULT = "";
    public static final String VALUE_PROJECTION_TYPE_CONFIG = "value.projection.type";
    private static final String VALUE_PROJECTION_TYPE_DISPLAY = "The type of value projection to use";
    private static final String VALUE_PROJECTION_TYPE_DOC = "The type of value projection to use";
    private static final String VALUE_PROJECTION_TYPE_DEFAULT = "none";
    public static final String VALUE_PROJECTION_LIST_CONFIG = "value.projection.list";
    private static final String VALUE_PROJECTION_LIST_DISPLAY = "The value projection list";
    private static final String VALUE_PROJECTION_LIST_DOC = "A comma separated list of field names for value projection";
    private static final String VALUE_PROJECTION_LIST_DEFAULT = "";
    public static final String FIELD_RENAMER_MAPPING_CONFIG = "field.renamer.mapping";
    private static final String FIELD_RENAMER_MAPPING_DISPLAY = "The field renamer mapping";
    private static final String FIELD_RENAMER_MAPPING_DOC = "An inline JSON array with objects describing field name mappings.\nExample: `[{\"oldName\":\"key.fieldA\",\"newName\":\"field1\"},{\"oldName\":\"value.xyz\",\"newName\":\"abc\"}]`";
    private static final String FIELD_RENAMER_MAPPING_DEFAULT = "[]";
    public static final String FIELD_RENAMER_REGEXP_CONFIG = "field.renamer.regexp";
    public static final String FIELD_RENAMER_REGEXP_DISPLAY = "The field renamer regex";
    private static final String FIELD_RENAMER_REGEXP_DOC = "An inline JSON array with objects describing regexp settings.\nExample: `[[{\"regexp\":\"^key\\\\\\\\..*my.*$\",\"pattern\":\"my\",\"replace\":\"\"},{\"regexp\":\"^value\\\\\\\\..*$\",\"pattern\":\"\\\\\\\\.\",\"replace\":\"_\"}]`";
    private static final String FIELD_RENAMER_REGEXP_DEFAULT = "[]";
    public static final String POST_PROCESSOR_CHAIN_CONFIG = "post.processor.chain";
    private static final String POST_PROCESSOR_CHAIN_DISPLAY = "The post processor chain";
    private static final String POST_PROCESSOR_CHAIN_DOC = "A comma separated list of post processor classes to process the data before saving to MongoDB.";
    private static final String POST_PROCESSOR_CHAIN_DEFAULT = "com.mongodb.kafka.connect.sink.processor.DocumentIdAdder";
    public static final String CHANGE_DATA_CAPTURE_HANDLER_CONFIG = "change.data.capture.handler";
    private static final String CHANGE_DATA_CAPTURE_HANDLER_DISPLAY = "The CDC handler";
    private static final String CHANGE_DATA_CAPTURE_HANDLER_DOC = "The class name of the CDC handler to use for processing";
    private static final String CHANGE_DATA_CAPTURE_HANDLER_DEFAULT = "";
    public static final String DELETE_ON_NULL_VALUES_CONFIG = "delete.on.null.values";
    private static final String DELETE_ON_NULL_VALUES_DISPLAY = "Delete on null values";
    private static final String DELETE_ON_NULL_VALUES_DOC = "Whether or not the connector tries to delete documents based on key when value is null";
    private static final boolean DELETE_ON_NULL_VALUES_DEFAULT = false;
    public static final String WRITEMODEL_STRATEGY_CONFIG = "writemodel.strategy";
    private static final String WRITEMODEL_STRATEGY_DISPLAY = "The writeModel strategy";
    private static final String WRITEMODEL_STRATEGY_DOC = "The class the handles how build the write models for the sink documents";
    private static final String WRITEMODEL_STRATEGY_DEFAULT = "com.mongodb.kafka.connect.sink.writemodel.strategy.ReplaceOneDefaultStrategy";
    public static final String MAX_BATCH_SIZE_CONFIG = "max.batch.size";
    private static final String MAX_BATCH_SIZE_DISPLAY = "The maximum batch size";
    private static final String MAX_BATCH_SIZE_DOC = "The maximum number of sink records to possibly batch together for processing";
    private static final int MAX_BATCH_SIZE_DEFAULT = 0;
    public static final String RATE_LIMITING_TIMEOUT_CONFIG = "rate.limiting.timeout";
    private static final String RATE_LIMITING_TIMEOUT_DISPLAY = "The rate limiting timeout";
    private static final String RATE_LIMITING_TIMEOUT_DOC = "How long in ms processing should wait before continue processing";
    private static final int RATE_LIMITING_TIMEOUT_DEFAULT = 0;
    public static final String RATE_LIMITING_EVERY_N_CONFIG = "rate.limiting.every.n";
    private static final String RATE_LIMITING_EVERY_N_DISPLAY = "The rate limiting batch number";
    private static final String RATE_LIMITING_EVERY_N_DOC = "After how many processed batches the rate limit should trigger (NO rate limiting if n=0)";
    private static final int RATE_LIMITING_EVERY_N_DEFAULT = 0;
    private static final Pattern CLASS_NAME = Pattern.compile("\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*");
    private static final Pattern FULLY_QUALIFIED_CLASS_NAME = Pattern.compile("(" + CLASS_NAME + "\\.)*" + CLASS_NAME);
    public static final String ID_FIELD = "_id";
    private static final List<Consumer<MongoSinkTopicConfig>> INITIALIZERS = Arrays.asList(MongoSinkTopicConfig::getNamespace, MongoSinkTopicConfig::getIdStrategy, MongoSinkTopicConfig::getPostProcessors, MongoSinkTopicConfig::getWriteModelStrategy, MongoSinkTopicConfig::getDeleteOneWriteModelStrategy, MongoSinkTopicConfig::getRateLimitSettings, MongoSinkTopicConfig::getCdcHandler);
    private final String topic;
    private MongoNamespace namespace;
    private IdStrategy idStrategy;
    private PostProcessors postProcessors;
    private WriteModelStrategy writeModelStrategy;
    private WriteModelStrategy deleteOneWriteModelStrategy;
    private RateLimitSettings rateLimitSettings;
    private CdcHandler cdcHandler;
    static final ConfigDef BASE_CONFIG = MongoSinkTopicConfig.createConfigDef();
    static final ConfigDef CONFIG = MongoSinkTopicConfig.createConfigDef().define("topic", ConfigDef.Type.STRING, ConfigDef.NO_DEFAULT_VALUE, ConfigDef.Importance.HIGH, "Topic name");

    MongoSinkTopicConfig(String topic, Map<String, String> originals) {
        this(topic, originals, true);
    }

    private MongoSinkTopicConfig(String topic, Map<String, String> originals, boolean initializeAll) {
        super(CONFIG, MongoSinkTopicConfig.createSinkTopicOriginals(topic, originals));
        this.topic = topic;
        if (initializeAll) {
            INITIALIZERS.forEach(i -> i.accept(this));
        }
    }

    public String getTopic() {
        return this.topic;
    }

    MongoNamespace getNamespace() {
        if (this.namespace == null) {
            String database = this.getString(DATABASE_CONFIG);
            if (database.isEmpty()) {
                throw new ConnectConfigException(DATABASE_CONFIG, database, "Missing database name for configuration.");
            }
            String collection = this.getString(COLLECTION_CONFIG);
            if (collection.isEmpty()) {
                collection = this.topic;
            }
            this.namespace = new MongoNamespace(database, collection);
        }
        return this.namespace;
    }

    public IdStrategy getIdStrategy() {
        if (this.idStrategy == null) {
            String className = this.getString(DOCUMENT_ID_STRATEGY_CONFIG);
            Optional<FieldProjector> fieldProjector = this.getFieldProjector(className);
            this.idStrategy = ClassHelper.createInstance(DOCUMENT_ID_STRATEGY_CONFIG, className, IdStrategy.class, () -> {
                boolean hasFieldProjectorConstructor;
                Class<?> clazz = Class.forName(className);
                boolean bl = hasFieldProjectorConstructor = fieldProjector.isPresent() && Arrays.stream(clazz.getConstructors()).anyMatch(i -> i.getParameterTypes().length == 1 && i.getParameterTypes()[0].equals(FieldProjector.class));
                if (hasFieldProjectorConstructor) {
                    return (IdStrategy)clazz.getConstructor(FieldProjector.class).newInstance(fieldProjector.get());
                }
                return (IdStrategy)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            });
        }
        return this.idStrategy;
    }

    PostProcessors getPostProcessors() {
        if (this.postProcessors == null) {
            this.postProcessors = new PostProcessors(this, this.getList(POST_PROCESSOR_CHAIN_CONFIG));
        }
        return this.postProcessors;
    }

    WriteModelStrategy getWriteModelStrategy() {
        if (this.writeModelStrategy == null) {
            this.writeModelStrategy = ClassHelper.createInstance(WRITEMODEL_STRATEGY_CONFIG, this.getString(WRITEMODEL_STRATEGY_CONFIG), WriteModelStrategy.class);
        }
        return this.writeModelStrategy;
    }

    Optional<WriteModelStrategy> getDeleteOneWriteModelStrategy() {
        if (!this.getBoolean(DELETE_ON_NULL_VALUES_CONFIG).booleanValue()) {
            return Optional.empty();
        }
        if (this.deleteOneWriteModelStrategy == null) {
            IdStrategy idStrategy = this.getIdStrategy();
            if (!(idStrategy instanceof FullKeyStrategy || idStrategy instanceof PartialKeyStrategy || idStrategy instanceof ProvidedInKeyStrategy)) {
                throw new ConnectConfigException(DELETE_ON_NULL_VALUES_CONFIG, this.getBoolean(DELETE_ON_NULL_VALUES_CONFIG), String.format("Error: %s can only be applied when the configured IdStrategy is an instance of: %s or %s or %s", DeleteOneDefaultStrategy.class.getSimpleName(), FullKeyStrategy.class.getSimpleName(), PartialKeyStrategy.class.getSimpleName(), ProvidedInKeyStrategy.class.getSimpleName()));
            }
            this.deleteOneWriteModelStrategy = new DeleteOneDefaultStrategy(idStrategy);
        }
        return Optional.of(this.deleteOneWriteModelStrategy);
    }

    Optional<CdcHandler> getCdcHandler() {
        String cdcHandler = this.getString(CHANGE_DATA_CAPTURE_HANDLER_CONFIG);
        if (cdcHandler.isEmpty()) {
            return Optional.empty();
        }
        if (this.cdcHandler == null) {
            this.cdcHandler = ClassHelper.createInstance(CHANGE_DATA_CAPTURE_HANDLER_CONFIG, cdcHandler, CdcHandler.class, () -> (CdcHandler)Class.forName(cdcHandler).getConstructor(MongoSinkTopicConfig.class).newInstance(new Object[]{this}));
        }
        return Optional.of(this.cdcHandler);
    }

    RateLimitSettings getRateLimitSettings() {
        if (this.rateLimitSettings == null) {
            this.rateLimitSettings = new RateLimitSettings(this.getInt(RATE_LIMITING_TIMEOUT_CONFIG), this.getInt(RATE_LIMITING_EVERY_N_CONFIG));
        }
        return this.rateLimitSettings;
    }

    static Map<String, ConfigValue> validateAll(String topic, Map<String, String> props) {
        String prefix = String.format("%s%s.", TOPIC_OVERRIDE_PREFIX, topic);
        List topicOverrides = props.keySet().stream().filter(k -> k.startsWith(prefix)).map(k -> k.substring(0, prefix.length())).collect(Collectors.toList());
        HashMap<String, ConfigValue> results = new HashMap<String, ConfigValue>();
        AtomicBoolean containsError = new AtomicBoolean();
        Map<String, String> sinkTopicOriginals = MongoSinkTopicConfig.createSinkTopicOriginals(topic, props);
        CONFIG.validateAll(sinkTopicOriginals).forEach((k, v) -> {
            if (!v.errorMessages().isEmpty()) {
                containsError.set(true);
            }
            String name = topicOverrides.contains(k) ? prefix + k : k;
            results.put(name, new ConfigValue(name, v.value(), v.recommendedValues(), v.errorMessages()));
        });
        if (!containsError.get()) {
            MongoSinkTopicConfig cfg = new MongoSinkTopicConfig(topic, sinkTopicOriginals, false);
            INITIALIZERS.forEach(i -> {
                try {
                    i.accept(cfg);
                }
                catch (ConnectConfigException t) {
                    results.put(t.getName(), new ConfigValue(t.getName(), t.getValue(), Collections.emptyList(), Collections.singletonList(t.getMessage())));
                }
            });
        }
        return results;
    }

    private static Map<String, String> createSinkTopicOriginals(String topic, Map<String, String> originals) {
        HashMap<String, String> topicConfig = new HashMap<String, String>();
        HashMap topicOverrides = new HashMap();
        String topicOverridePrefix = String.format("%s%s", TOPIC_OVERRIDE_PREFIX, topic);
        topicConfig.put(TOPIC_CONFIG, topic);
        originals.forEach((k, v) -> {
            if (!(k.startsWith(TOPIC_OVERRIDE_PREFIX) || k.equals("connection.uri") || k.equals("topics"))) {
                topicConfig.put((String)k, (String)v);
            }
            if (k.startsWith(topicOverridePrefix)) {
                topicOverrides.put(k.substring(topicOverridePrefix.length() + 1), v);
            }
        });
        topicConfig.putAll(topicOverrides);
        return topicConfig;
    }

    private Optional<FieldProjector> getFieldProjector(String strategyClassName) {
        FieldProjectionType keyProjectionType = FieldProjectionType.valueOf(this.getString(KEY_PROJECTION_TYPE_CONFIG).toUpperCase());
        FieldProjectionType valueProjectionType = FieldProjectionType.valueOf(this.getString(VALUE_PROJECTION_TYPE_CONFIG).toUpperCase());
        if (keyProjectionType.equals((Object)FieldProjectionType.NONE) && strategyClassName.equals(PartialKeyStrategy.class.getName())) {
            throw new ConnectConfigException(DOCUMENT_ID_STRATEGY_CONFIG, strategyClassName, String.format("Invalid %s value", KEY_PROJECTION_TYPE_CONFIG));
        }
        if (valueProjectionType.equals((Object)FieldProjectionType.NONE) && strategyClassName.equals(PartialValueStrategy.class.getName())) {
            throw new ConnectConfigException(DOCUMENT_ID_STRATEGY_CONFIG, strategyClassName, String.format("Invalid %s value", VALUE_PROJECTION_TYPE_CONFIG));
        }
        if (keyProjectionType.equals((Object)FieldProjectionType.BLACKLIST)) {
            return Optional.of(new BlacklistKeyProjector(this));
        }
        if (keyProjectionType.equals((Object)FieldProjectionType.WHITELIST)) {
            return Optional.of(new WhitelistKeyProjector(this));
        }
        if (valueProjectionType.equals((Object)FieldProjectionType.BLACKLIST)) {
            return Optional.of(new BlacklistValueProjector(this));
        }
        if (valueProjectionType.equals((Object)FieldProjectionType.WHITELIST)) {
            return Optional.of(new WhitelistValueProjector(this));
        }
        return Optional.empty();
    }

    private static ConfigDef createConfigDef() {
        ConfigDef configDef = new ConfigDef();
        String group = "Namespace";
        int orderInGroup = 0;
        configDef.define(DATABASE_CONFIG, ConfigDef.Type.STRING, ConfigDef.NO_DEFAULT_VALUE, (ConfigDef.Validator)new ConfigDef.NonEmptyString(), ConfigDef.Importance.HIGH, DATABASE_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, DATABASE_DISPLAY);
        configDef.define(COLLECTION_CONFIG, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.HIGH, COLLECTION_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, COLLECTION_DISPLAY);
        group = "Writes";
        orderInGroup = 0;
        configDef.define(MAX_NUM_RETRIES_CONFIG, ConfigDef.Type.INT, (Object)3, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, MAX_NUM_RETRIES_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, MAX_NUM_RETRIES_DISPLAY);
        configDef.define(RETRIES_DEFER_TIMEOUT_CONFIG, ConfigDef.Type.INT, (Object)5000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, RETRIES_DEFER_TIMEOUT_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, RETRIES_DEFER_TIMEOUT_DISPLAY);
        configDef.define(DELETE_ON_NULL_VALUES_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.MEDIUM, DELETE_ON_NULL_VALUES_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, DELETE_ON_NULL_VALUES_DISPLAY);
        configDef.define(WRITEMODEL_STRATEGY_CONFIG, ConfigDef.Type.STRING, (Object)WRITEMODEL_STRATEGY_DEFAULT, (ConfigDef.Validator)Validators.matching(FULLY_QUALIFIED_CLASS_NAME), ConfigDef.Importance.LOW, WRITEMODEL_STRATEGY_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, WRITEMODEL_STRATEGY_DISPLAY);
        configDef.define(MAX_BATCH_SIZE_CONFIG, ConfigDef.Type.INT, (Object)0, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, MAX_BATCH_SIZE_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, MAX_BATCH_SIZE_DISPLAY);
        configDef.define(RATE_LIMITING_TIMEOUT_CONFIG, ConfigDef.Type.INT, (Object)0, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.LOW, RATE_LIMITING_TIMEOUT_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, RATE_LIMITING_TIMEOUT_DISPLAY);
        configDef.define(RATE_LIMITING_EVERY_N_CONFIG, ConfigDef.Type.INT, (Object)0, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.LOW, RATE_LIMITING_EVERY_N_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, RATE_LIMITING_EVERY_N_DISPLAY);
        group = "Post Processing";
        orderInGroup = 0;
        configDef.define(POST_PROCESSOR_CHAIN_CONFIG, ConfigDef.Type.LIST, (Object)POST_PROCESSOR_CHAIN_DEFAULT, (ConfigDef.Validator)Validators.listMatchingPattern(FULLY_QUALIFIED_CLASS_NAME), ConfigDef.Importance.LOW, POST_PROCESSOR_CHAIN_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, POST_PROCESSOR_CHAIN_DISPLAY);
        configDef.define(KEY_PROJECTION_TYPE_CONFIG, ConfigDef.Type.STRING, (Object)"none", (ConfigDef.Validator)Validators.EnumValidatorAndRecommender.in(FieldProjectionType.values()), ConfigDef.Importance.LOW, KEY_PROJECTION_TYPE_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, KEY_PROJECTION_TYPE_DISPLAY, (ConfigDef.Recommender)Validators.EnumValidatorAndRecommender.in(FieldProjectionType.values()));
        configDef.define(KEY_PROJECTION_LIST_CONFIG, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, KEY_PROJECTION_LIST_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, KEY_PROJECTION_LIST_DISPLAY, Collections.singletonList(KEY_PROJECTION_TYPE_CONFIG));
        configDef.define(VALUE_PROJECTION_TYPE_CONFIG, ConfigDef.Type.STRING, (Object)"none", (ConfigDef.Validator)Validators.EnumValidatorAndRecommender.in(FieldProjectionType.values()), ConfigDef.Importance.LOW, "The type of value projection to use", group, ++orderInGroup, ConfigDef.Width.MEDIUM, "The type of value projection to use", (ConfigDef.Recommender)Validators.EnumValidatorAndRecommender.in(FieldProjectionType.values()));
        configDef.define(VALUE_PROJECTION_LIST_CONFIG, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, VALUE_PROJECTION_LIST_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, VALUE_PROJECTION_LIST_DISPLAY, Collections.singletonList(VALUE_PROJECTION_TYPE_CONFIG));
        configDef.define(FIELD_RENAMER_MAPPING_CONFIG, ConfigDef.Type.STRING, (Object)"[]", (ConfigDef.Validator)Validators.errorCheckingValueValidator("A valid JSON array", ConfigHelper::jsonArrayFromString), ConfigDef.Importance.LOW, FIELD_RENAMER_MAPPING_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, FIELD_RENAMER_MAPPING_DISPLAY);
        configDef.define(FIELD_RENAMER_REGEXP_CONFIG, ConfigDef.Type.STRING, (Object)"[]", (ConfigDef.Validator)Validators.errorCheckingValueValidator("A valid JSON array", ConfigHelper::jsonArrayFromString), ConfigDef.Importance.LOW, FIELD_RENAMER_REGEXP_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, FIELD_RENAMER_REGEXP_DISPLAY);
        group = "Id Strategies";
        orderInGroup = 0;
        configDef.define(DOCUMENT_ID_STRATEGY_CONFIG, ConfigDef.Type.STRING, (Object)DOCUMENT_ID_STRATEGY_DEFAULT, (ConfigDef.Validator)Validators.emptyString().or(Validators.matching(FULLY_QUALIFIED_CLASS_NAME)), ConfigDef.Importance.HIGH, DOCUMENT_ID_STRATEGY_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, DOCUMENT_ID_STRATEGY_DISPLAY);
        group = "Change Data Capture";
        orderInGroup = 0;
        configDef.define(CHANGE_DATA_CAPTURE_HANDLER_CONFIG, ConfigDef.Type.STRING, (Object)"", (ConfigDef.Validator)Validators.emptyString().or(Validators.matching(FULLY_QUALIFIED_CLASS_NAME)), ConfigDef.Importance.LOW, CHANGE_DATA_CAPTURE_HANDLER_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, CHANGE_DATA_CAPTURE_HANDLER_DISPLAY);
        return configDef;
    }

    public static enum FieldProjectionType {
        NONE,
        BLACKLIST,
        WHITELIST;

    }
}

