/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink.processor.field.projection;

import com.mongodb.kafka.connect.sink.MongoSinkTopicConfig;
import com.mongodb.kafka.connect.sink.processor.PostProcessor;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.AbstractConfig;
import org.bson.BsonDocument;

public abstract class FieldProjector
extends PostProcessor {
    private static final String FIELD_LIST_SPLIT_EXPR = "\\s*,\\s*";
    static final String SINGLE_WILDCARD = "*";
    static final String DOUBLE_WILDCARD = "**";
    static final String SUB_FIELD_DOT_SEPARATOR = ".";
    private final Set<String> fields;

    public FieldProjector(MongoSinkTopicConfig config, Set<String> fields) {
        super(config);
        this.fields = fields;
    }

    public Set<String> getFields() {
        return this.fields;
    }

    protected abstract void doProjection(String var1, BsonDocument var2);

    protected static Set<String> getKeyFields(AbstractConfig config) {
        return FieldProjector.buildProjectionList(config.getString("key.projection.type"), config.getString("key.projection.list"));
    }

    protected static Set<String> getValueFields(AbstractConfig config) {
        return FieldProjector.buildProjectionList(config.getString("value.projection.type"), config.getString("value.projection.list"));
    }

    private static Set<String> buildProjectionList(String projectionType, String fieldList) {
        if (projectionType.equalsIgnoreCase(MongoSinkTopicConfig.FieldProjectionType.BLACKLIST.name())) {
            return new HashSet<String>(FieldProjector.toList(fieldList));
        }
        if (projectionType.equalsIgnoreCase(MongoSinkTopicConfig.FieldProjectionType.WHITELIST.name())) {
            HashSet<String> whitelistExpanded = new HashSet<String>();
            List<String> fields = FieldProjector.toList(fieldList);
            Iterator<String> iterator = fields.iterator();
            while (iterator.hasNext()) {
                String f;
                String entry = f = iterator.next();
                whitelistExpanded.add(entry);
                while (entry.contains(SUB_FIELD_DOT_SEPARATOR)) {
                    if ((entry = entry.substring(0, entry.lastIndexOf(SUB_FIELD_DOT_SEPARATOR))).isEmpty()) continue;
                    whitelistExpanded.add(entry);
                }
            }
            return whitelistExpanded;
        }
        return new HashSet<String>();
    }

    private static List<String> toList(String value) {
        return Arrays.stream(value.trim().split(FIELD_LIST_SPLIT_EXPR)).filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }
}

