/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink.writemodel.strategy;

import com.mongodb.client.model.DeleteOneModel;
import com.mongodb.client.model.WriteModel;
import com.mongodb.kafka.connect.sink.converter.SinkDocument;
import com.mongodb.kafka.connect.sink.processor.id.strategy.IdStrategy;
import com.mongodb.kafka.connect.sink.writemodel.strategy.WriteModelStrategy;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.sink.SinkRecord;
import org.bson.BsonDocument;
import org.bson.BsonValue;

public class DeleteOneDefaultStrategy
implements WriteModelStrategy {
    private IdStrategy idStrategy;

    public DeleteOneDefaultStrategy() {
        this(new DefaultIdFieldStrategy());
    }

    public DeleteOneDefaultStrategy(IdStrategy idStrategy) {
        this.idStrategy = idStrategy;
    }

    @Override
    public WriteModel<BsonDocument> createWriteModel(SinkDocument document) {
        document.getKeyDoc().orElseThrow(() -> new DataException("Error: cannot build the WriteModel since the key document was missing unexpectedly"));
        BsonDocument deleteFilter = this.idStrategy instanceof DefaultIdFieldStrategy ? this.idStrategy.generateId(document, null).asDocument() : new BsonDocument("_id", this.idStrategy.generateId(document, null));
        return new DeleteOneModel<BsonDocument>(deleteFilter);
    }

    static class DefaultIdFieldStrategy
    implements IdStrategy {
        DefaultIdFieldStrategy() {
        }

        @Override
        public BsonValue generateId(SinkDocument doc, SinkRecord orig) {
            BsonDocument kd = doc.getKeyDoc().get();
            return kd.containsKey("_id") ? kd : new BsonDocument("_id", kd);
        }
    }
}

