/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink.writemodel.strategy;

import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.kafka.connect.sink.converter.SinkDocument;
import com.mongodb.kafka.connect.sink.writemodel.strategy.WriteModelStrategy;
import org.apache.kafka.connect.errors.DataException;
import org.bson.BSONException;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;

public class ReplaceOneBusinessKeyStrategy
implements WriteModelStrategy {
    private static final ReplaceOptions REPLACE_OPTIONS = new ReplaceOptions().upsert(true);

    @Override
    public WriteModel<BsonDocument> createWriteModel(SinkDocument document) {
        BsonDocument vd = document.getValueDoc().orElseThrow(() -> new DataException("Error: cannot build the WriteModel since the value document was missing unexpectedly"));
        try {
            BsonDocument businessKey = vd.getDocument("_id");
            vd.remove("_id");
            return new ReplaceOneModel<BsonDocument>((Bson)businessKey, vd, REPLACE_OPTIONS);
        }
        catch (BSONException e) {
            throw new DataException("Error: cannot build the WriteModel since the value document does not contain an _id field of type BsonDocument which holds the business key fields");
        }
    }
}

