/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink.writemodel.strategy;

import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.kafka.connect.sink.converter.SinkDocument;
import com.mongodb.kafka.connect.sink.writemodel.strategy.WriteModelStrategy;
import java.time.Instant;
import org.apache.kafka.connect.errors.DataException;
import org.bson.BsonDateTime;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;

public class UpdateOneTimestampsStrategy
implements WriteModelStrategy {
    private static final UpdateOptions UPDATE_OPTIONS = new UpdateOptions().upsert(true);
    static final String FIELD_NAME_MODIFIED_TS = "_modifiedTS";
    static final String FIELD_NAME_INSERTED_TS = "_insertedTS";

    @Override
    public WriteModel<BsonDocument> createWriteModel(SinkDocument document) {
        BsonDocument vd = document.getValueDoc().orElseThrow(() -> new DataException("Error: cannot build the WriteModel since the value document was missing unexpectedly"));
        BsonDateTime dateTime = new BsonDateTime(Instant.now().toEpochMilli());
        return new UpdateOneModel<BsonDocument>((Bson)new BsonDocument("_id", vd.get("_id")), new BsonDocument("$set", vd.append(FIELD_NAME_MODIFIED_TS, dateTime)).append("$setOnInsert", new BsonDocument(FIELD_NAME_INSERTED_TS, dateTime)), UPDATE_OPTIONS);
    }
}

