/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.source;

import com.mongodb.ConnectionString;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.changestream.FullDocument;
import com.mongodb.kafka.connect.util.ConfigHelper;
import com.mongodb.kafka.connect.util.ConnectConfigException;
import com.mongodb.kafka.connect.util.Validators;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigValue;
import org.bson.Document;

public class MongoSourceConfig
extends AbstractConfig {
    public static final String CONNECTION_URI_CONFIG = "connection.uri";
    private static final String CONNECTION_URI_DEFAULT = "mongodb://localhost:27017,localhost:27018,localhost:27019";
    private static final String CONNECTION_URI_DISPLAY = "MongoDB Connection URI";
    private static final String CONNECTION_URI_DOC = "The connection URI as supported by the official drivers. eg: ``mongodb://user@pass@locahost/``.";
    public static final String TOPIC_PREFIX_CONFIG = "topic.prefix";
    private static final String TOPIC_PREFIX_DOC = "Prefix to prepend to database & collection names to generate the name of the Kafka topic to publish data to.";
    private static final String TOPIC_PREFIX_DISPLAY = "Topic Prefix";
    private static final String TOPIC_PREFIX_DEFAULT = "";
    public static final String PIPELINE_CONFIG = "pipeline";
    private static final String PIPELINE_DISPLAY = "The pipeline to apply to the change stream";
    private static final String PIPELINE_DOC = "An inline JSON array with objects describing the pipeline operations to run.\nExample: `[{\"$match\": {\"operationType\": \"insert\"}}, {\"$addFields\": {\"Kafka\": \"Rules!\"}}]`";
    private static final String PIPELINE_DEFAULT = "[]";
    public static final String BATCH_SIZE_CONFIG = "batch.size";
    private static final String BATCH_SIZE_DISPLAY = "The cursor batch size";
    private static final String BATCH_SIZE_DOC = "The cursor batch size.";
    private static final int BATCH_SIZE_DEFAULT = 0;
    public static final String PUBLISH_FULL_DOCUMENT_ONLY_CONFIG = "publish.full.document.only";
    private static final String PUBLISH_FULL_DOCUMENT_ONLY_DISPLAY = "Publish only the `fullDocument` field";
    private static final String PUBLISH_FULL_DOCUMENT_ONLY_DOC = "Only publish the actual changed document rather than the full change stream document. Automatically, sets `change.stream.full.document=updateLookup` so updated documents will be included.";
    private static final boolean PUBLISH_FULL_DOCUMENT_ONLY_DEFAULT = false;
    public static final String FULL_DOCUMENT_CONFIG = "change.stream.full.document";
    private static final String FULL_DOCUMENT_DISPLAY = "Set what to return for update operations";
    private static final String FULL_DOCUMENT_DOC = "Determines what to return for update operations when using a Change Stream.\nWhen set to 'updateLookup', the change stream for partial updates will include both a delta describing the changes to the document as well as a copy of the entire document that was changed from *some time* after the change occurred.";
    private static final String FULL_DOCUMENT_DEFAULT = "";
    public static final String COLLATION_CONFIG = "collation";
    private static final String COLLATION_DISPLAY = "The collation options";
    private static final String COLLATION_DOC = "The json representation of the Collation options to use for the change stream.\nUse the `Collation.asDocument().toJson()` to create the specific json representation.";
    private static final String COLLATION_DEFAULT = "";
    public static final String POLL_MAX_BATCH_SIZE_CONFIG = "poll.max.batch.size";
    private static final String POLL_MAX_BATCH_SIZE_DISPLAY = "The maximum batch size";
    private static final String POLL_MAX_BATCH_SIZE_DOC = "Maximum number of change stream documents to include in a single batch when polling for new data. This setting can be used to limit the amount of data buffered internally in the connector.";
    private static final int POLL_MAX_BATCH_SIZE_DEFAULT = 1000;
    public static final String POLL_AWAIT_TIME_MS_CONFIG = "poll.await.time.ms";
    private static final String POLL_AWAIT_TIME_MS_DOC = "The amount of time to wait before checking for new results on the change stream";
    private static final int POLL_AWAIT_TIME_MS_DEFAULT = 5000;
    private static final String POLL_AWAIT_TIME_MS_DISPLAY = "Poll await time (ms)";
    public static final String DATABASE_CONFIG = "database";
    private static final String DATABASE_DISPLAY = "The database to watch.";
    private static final String DATABASE_DOC = "The database to watch. If not set then all databases will be watched.";
    private static final String DATABASE_DEFAULT = "";
    public static final String COLLECTION_CONFIG = "collection";
    private static final String COLLECTION_DISPLAY = "The collection to watch.";
    private static final String COLLECTION_DOC = "The collection in the database to watch. If not set then all collections will be watched.";
    private static final String COLLECTION_DEFAULT = "";
    public static final String COPY_EXISTING_CONFIG = "copy.existing";
    private static final String COPY_EXISTING_DISPLAY = "Copy existing data";
    private static final String COPY_EXISTING_DOC = "Copy existing data from all the collections being used as the source then add any changes after. It should be noted that the reading of all the data during the copy and then the subsequent change stream events may produce duplicated events. During the copy, clients can make changes to the data in MongoDB, which may be represented both by the copying process and the change stream. However, as the change stream events are idempotent the changes can be applied so that the data is eventually consistent. Renaming a collection during the copying process is not supported.";
    private static final boolean COPY_EXISTING_DEFAULT = false;
    public static final String COPY_EXISTING_MAX_THREADS_CONFIG = "copy.existing.max.threads";
    private static final String COPY_EXISTING_MAX_THREADS_DISPLAY = "Copy existing max number of threads";
    private static final String COPY_EXISTING_MAX_THREADS_DOC = "The number of threads to use when performing the data copy. Defaults to the number of processors";
    private static final int COPY_EXISTING_MAX_THREADS_DEFAULT = Runtime.getRuntime().availableProcessors();
    public static final String COPY_EXISTING_QUEUE_SIZE_CONFIG = "copy.existing.queue.size";
    private static final String COPY_EXISTING_QUEUE_SIZE_DISPLAY = "Copy existing queue size";
    private static final String COPY_EXISTING_QUEUE_SIZE_DOC = "The max size of the queue to use when copying data.";
    private static final int COPY_EXISTING_QUEUE_SIZE_DEFAULT = 16000;
    public static final ConfigDef CONFIG = MongoSourceConfig.createConfigDef();
    private static final List<Consumer<MongoSourceConfig>> INITIALIZERS = Collections.singletonList(MongoSourceConfig::validateCollection);
    private final ConnectionString connectionString = new ConnectionString(this.getString("connection.uri"));

    public MongoSourceConfig(Map<?, ?> originals) {
        this(originals, true);
    }

    private MongoSourceConfig(Map<?, ?> originals, boolean validateAll) {
        super(CONFIG, originals, false);
        if (validateAll) {
            INITIALIZERS.forEach(i -> i.accept(this));
        }
    }

    public ConnectionString getConnectionString() {
        return this.connectionString;
    }

    public Optional<List<Document>> getPipeline() {
        return ConfigHelper.jsonArrayFromString(this.getString(PIPELINE_CONFIG));
    }

    public Optional<Collation> getCollation() {
        return ConfigHelper.collationFromJson(this.getString(COLLATION_CONFIG));
    }

    public Optional<FullDocument> getFullDocument() {
        if (this.getBoolean(PUBLISH_FULL_DOCUMENT_ONLY_CONFIG).booleanValue()) {
            return Optional.of(FullDocument.UPDATE_LOOKUP);
        }
        return ConfigHelper.fullDocumentFromString(this.getString(FULL_DOCUMENT_CONFIG));
    }

    private void validateCollection() {
        String database = this.getString(DATABASE_CONFIG);
        String collection = this.getString(COLLECTION_CONFIG);
        if (!collection.isEmpty() && database.isEmpty()) {
            throw new ConnectConfigException(COLLECTION_CONFIG, collection, String.format("Missing database configuration `%s`", DATABASE_CONFIG));
        }
    }

    private static ConfigDef createConfigDef() {
        ConfigDef configDef = new ConfigDef(){

            public Map<String, ConfigValue> validateAll(Map<String, String> props) {
                Map results = super.validateAll(props);
                if (results.values().stream().anyMatch(c -> !c.errorMessages().isEmpty())) {
                    return results;
                }
                MongoSourceConfig cfg = new MongoSourceConfig(props, false);
                INITIALIZERS.forEach(i -> {
                    try {
                        i.accept(cfg);
                    }
                    catch (ConnectConfigException t) {
                        results.put(t.getName(), new ConfigValue(t.getName(), t.getValue(), Collections.emptyList(), Collections.singletonList(t.getMessage())));
                    }
                });
                return results;
            }
        };
        String group = "ChangeStream";
        int orderInGroup = 0;
        configDef.define(CONNECTION_URI_CONFIG, ConfigDef.Type.STRING, (Object)CONNECTION_URI_DEFAULT, (ConfigDef.Validator)Validators.errorCheckingValueValidator("A valid connection string", ConnectionString::new), ConfigDef.Importance.HIGH, CONNECTION_URI_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, CONNECTION_URI_DISPLAY);
        configDef.define(COPY_EXISTING_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.MEDIUM, COPY_EXISTING_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, COPY_EXISTING_DISPLAY);
        configDef.define(COPY_EXISTING_MAX_THREADS_CONFIG, ConfigDef.Type.INT, (Object)COPY_EXISTING_MAX_THREADS_DEFAULT, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, COPY_EXISTING_MAX_THREADS_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, COPY_EXISTING_MAX_THREADS_DISPLAY);
        configDef.define(COPY_EXISTING_QUEUE_SIZE_CONFIG, ConfigDef.Type.INT, (Object)16000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, COPY_EXISTING_QUEUE_SIZE_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, COPY_EXISTING_QUEUE_SIZE_DISPLAY);
        configDef.define(DATABASE_CONFIG, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, DATABASE_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, DATABASE_DISPLAY);
        configDef.define(COLLECTION_CONFIG, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, COLLECTION_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, COLLECTION_DISPLAY);
        configDef.define(PIPELINE_CONFIG, ConfigDef.Type.STRING, (Object)PIPELINE_DEFAULT, (ConfigDef.Validator)Validators.errorCheckingValueValidator("A valid JSON array", ConfigHelper::jsonArrayFromString), ConfigDef.Importance.MEDIUM, PIPELINE_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, PIPELINE_DISPLAY);
        configDef.define(BATCH_SIZE_CONFIG, ConfigDef.Type.INT, (Object)0, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, BATCH_SIZE_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, BATCH_SIZE_DISPLAY);
        configDef.define(PUBLISH_FULL_DOCUMENT_ONLY_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.HIGH, PUBLISH_FULL_DOCUMENT_ONLY_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, PUBLISH_FULL_DOCUMENT_ONLY_DISPLAY);
        configDef.define(FULL_DOCUMENT_CONFIG, ConfigDef.Type.STRING, (Object)"", (ConfigDef.Validator)Validators.emptyString().or(Validators.EnumValidatorAndRecommender.in(FullDocument.values(), FullDocument::getValue)), ConfigDef.Importance.HIGH, FULL_DOCUMENT_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, FULL_DOCUMENT_DISPLAY, (ConfigDef.Recommender)Validators.EnumValidatorAndRecommender.in(FullDocument.values(), FullDocument::getValue));
        configDef.define(COLLATION_CONFIG, ConfigDef.Type.STRING, (Object)"", (ConfigDef.Validator)Validators.errorCheckingValueValidator("A valid JSON document representing a collation", ConfigHelper::collationFromJson), ConfigDef.Importance.HIGH, COLLATION_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, COLLATION_DISPLAY);
        configDef.define(TOPIC_PREFIX_CONFIG, ConfigDef.Type.STRING, (Object)"", null, ConfigDef.Importance.LOW, TOPIC_PREFIX_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, TOPIC_PREFIX_DISPLAY);
        configDef.define(POLL_MAX_BATCH_SIZE_CONFIG, ConfigDef.Type.INT, (Object)1000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.LOW, POLL_MAX_BATCH_SIZE_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, POLL_MAX_BATCH_SIZE_DISPLAY);
        configDef.define(POLL_AWAIT_TIME_MS_CONFIG, ConfigDef.Type.LONG, (Object)5000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.LOW, POLL_AWAIT_TIME_MS_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, POLL_AWAIT_TIME_MS_DISPLAY);
        return configDef;
    }
}

