/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.util;

import com.mongodb.kafka.connect.util.ConnectConfigException;
import java.util.List;

public final class ClassHelper {
    public static <T> T createInstance(String configKey, String className, Class<T> clazz) {
        return (T)ClassHelper.createInstance(configKey, className, clazz, () -> Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]));
    }

    public static <T> T createInstance(String configKey, String className, Class<T> clazz, List<Class<?>> constructorArgs, List<Object> initArgs) {
        return (T)ClassHelper.createInstance(configKey, className, clazz, () -> Class.forName(className).getConstructor(constructorArgs.toArray(new Class[0])).newInstance(initArgs.toArray(new Object[0])));
    }

    public static <T> T createInstance(String configKey, String className, Class<T> clazz, ClassCreator<T> cc) {
        try {
            return cc.init();
        }
        catch (ClassCastException e) {
            throw new ConnectConfigException(configKey, className, String.format("Contract violation class doesn't implement: '%s'", clazz.getSimpleName()));
        }
        catch (Exception e) {
            if (e.getCause() instanceof ConnectConfigException) {
                throw (ConnectConfigException)((Object)e.getCause());
            }
            throw new ConnectConfigException(configKey, className, e.getMessage());
        }
    }

    private ClassHelper() {
    }

    @FunctionalInterface
    public static interface ClassCreator<T> {
        public T init() throws Exception;
    }
}

