/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.util;

import com.mongodb.MongoDriverInformation;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.CollationAlternate;
import com.mongodb.client.model.CollationCaseFirst;
import com.mongodb.client.model.CollationMaxVariable;
import com.mongodb.client.model.CollationStrength;
import com.mongodb.client.model.changestream.FullDocument;
import java.util.List;
import java.util.Optional;
import org.apache.kafka.common.config.ConfigException;
import org.bson.Document;

public final class ConfigHelper {
    private ConfigHelper() {
    }

    public static Optional<List<Document>> jsonArrayFromString(String jsonArray) {
        if (jsonArray.isEmpty()) {
            return Optional.empty();
        }
        try {
            List<Document> s = Document.parse(String.format("{s: %s}", jsonArray)).getList("s", Document.class);
            return s.isEmpty() ? Optional.empty() : Optional.of(s);
        }
        catch (Exception e) {
            throw new ConfigException("Not a valid JSON array");
        }
    }

    public static Optional<FullDocument> fullDocumentFromString(String fullDocument) {
        if (fullDocument.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(FullDocument.fromString(fullDocument));
    }

    public static Optional<Collation> collationFromJson(String collationString) {
        if (collationString.isEmpty()) {
            return Optional.empty();
        }
        Collation.Builder builder = Collation.builder();
        Document collationDoc = Document.parse(collationString);
        if (collationDoc.containsKey("locale")) {
            builder.locale(collationDoc.getString("locale"));
        }
        if (collationDoc.containsKey("caseLevel")) {
            builder.caseLevel(collationDoc.getBoolean("caseLevel"));
        }
        if (collationDoc.containsKey("caseFirst")) {
            builder.collationCaseFirst(CollationCaseFirst.fromString(collationDoc.getString("caseFirst")));
        }
        if (collationDoc.containsKey("strength")) {
            builder.collationStrength(CollationStrength.fromInt(collationDoc.getInteger("strength")));
        }
        if (collationDoc.containsKey("numericOrdering")) {
            builder.numericOrdering(collationDoc.getBoolean("numericOrdering"));
        }
        if (collationDoc.containsKey("alternate")) {
            builder.collationAlternate(CollationAlternate.fromString(collationDoc.getString("alternate")));
        }
        if (collationDoc.containsKey("maxVariable")) {
            builder.collationMaxVariable(CollationMaxVariable.fromString(collationDoc.getString("maxVariable")));
        }
        if (collationDoc.containsKey("normalization")) {
            builder.normalization(collationDoc.getBoolean("normalization"));
        }
        if (collationDoc.containsKey("backwards")) {
            builder.backwards(collationDoc.getBoolean("backwards"));
        }
        return Optional.of(builder.build());
    }

    public static MongoDriverInformation getMongoDriverInformation() {
        return MongoDriverInformation.builder().driverName("mongo-kafka").driverVersion("1.0.0").build();
    }
}

