/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model;

import com.mongodb.assertions.Assertions;
import java.util.Arrays;
import java.util.List;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

public final class Projections {
    private Projections() {
    }

    public static Bson include(String ... fieldNames) {
        return Projections.include(Arrays.asList(fieldNames));
    }

    public static Bson include(List<String> fieldNames) {
        return Projections.combine(fieldNames, (BsonValue)new BsonInt32(1));
    }

    public static Bson exclude(String ... fieldNames) {
        return Projections.exclude(Arrays.asList(fieldNames));
    }

    public static Bson exclude(List<String> fieldNames) {
        return Projections.combine(fieldNames, (BsonValue)new BsonInt32(0));
    }

    public static Bson excludeId() {
        return new BsonDocument("_id", (BsonValue)new BsonInt32(0));
    }

    public static Bson elemMatch(String fieldName) {
        return new BsonDocument(fieldName + ".$", (BsonValue)new BsonInt32(1));
    }

    public static Bson elemMatch(final String fieldName, final Bson filter) {
        return new Bson(){

            public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
                return new BsonDocument(fieldName, (BsonValue)new BsonDocument("$elemMatch", (BsonValue)filter.toBsonDocument(documentClass, codecRegistry)));
            }
        };
    }

    public static Bson metaTextScore(String fieldName) {
        return new BsonDocument(fieldName, (BsonValue)new BsonDocument("$meta", (BsonValue)new BsonString("textScore")));
    }

    public static Bson slice(String fieldName, int limit) {
        return new BsonDocument(fieldName, (BsonValue)new BsonDocument("$slice", (BsonValue)new BsonInt32(limit)));
    }

    public static Bson slice(String fieldName, int skip, int limit) {
        return new BsonDocument(fieldName, (BsonValue)new BsonDocument("$slice", (BsonValue)new BsonArray(Arrays.asList(new BsonInt32(skip), new BsonInt32(limit)))));
    }

    public static Bson fields(Bson ... projections) {
        return Projections.fields(Arrays.asList(projections));
    }

    public static Bson fields(final List<Bson> projections) {
        Assertions.notNull("sorts", projections);
        return new Bson(){

            public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
                BsonDocument combinedDocument = new BsonDocument();
                for (Bson sort : projections) {
                    BsonDocument sortDocument = sort.toBsonDocument(documentClass, codecRegistry);
                    for (String key : sortDocument.keySet()) {
                        combinedDocument.remove((Object)key);
                        combinedDocument.append(key, sortDocument.get((Object)key));
                    }
                }
                return combinedDocument;
            }
        };
    }

    private static Bson combine(List<String> fieldNames, BsonValue value) {
        BsonDocument document = new BsonDocument();
        for (String fieldName : fieldNames) {
            document.remove((Object)fieldName);
            document.append(fieldName, value);
        }
        return document;
    }
}

