/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.bulk;

import com.mongodb.MongoNamespace;
import com.mongodb.annotations.Sealed;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.bulk.ClientDeleteManyOptions;
import com.mongodb.client.model.bulk.ClientDeleteOneOptions;
import com.mongodb.client.model.bulk.ClientNamespacedDeleteManyModel;
import com.mongodb.client.model.bulk.ClientNamespacedDeleteOneModel;
import com.mongodb.client.model.bulk.ClientNamespacedInsertOneModel;
import com.mongodb.client.model.bulk.ClientNamespacedReplaceOneModel;
import com.mongodb.client.model.bulk.ClientNamespacedUpdateManyModel;
import com.mongodb.client.model.bulk.ClientNamespacedUpdateOneModel;
import com.mongodb.client.model.bulk.ClientReplaceOneOptions;
import com.mongodb.client.model.bulk.ClientUpdateManyOptions;
import com.mongodb.client.model.bulk.ClientUpdateOneOptions;
import com.mongodb.internal.client.model.bulk.ConcreteClientDeleteManyModel;
import com.mongodb.internal.client.model.bulk.ConcreteClientDeleteOneModel;
import com.mongodb.internal.client.model.bulk.ConcreteClientInsertOneModel;
import com.mongodb.internal.client.model.bulk.ConcreteClientNamespacedDeleteManyModel;
import com.mongodb.internal.client.model.bulk.ConcreteClientNamespacedDeleteOneModel;
import com.mongodb.internal.client.model.bulk.ConcreteClientNamespacedInsertOneModel;
import com.mongodb.internal.client.model.bulk.ConcreteClientNamespacedReplaceOneModel;
import com.mongodb.internal.client.model.bulk.ConcreteClientNamespacedUpdateManyModel;
import com.mongodb.internal.client.model.bulk.ConcreteClientNamespacedUpdateOneModel;
import com.mongodb.internal.client.model.bulk.ConcreteClientReplaceOneModel;
import com.mongodb.internal.client.model.bulk.ConcreteClientUpdateManyModel;
import com.mongodb.internal.client.model.bulk.ConcreteClientUpdateOneModel;
import org.bson.conversions.Bson;

@Sealed
public interface ClientNamespacedWriteModel {
    public static <TDocument> ClientNamespacedInsertOneModel insertOne(MongoNamespace namespace, TDocument document) {
        Assertions.notNull("namespace", namespace);
        Assertions.notNull("document", document);
        return new ConcreteClientNamespacedInsertOneModel(namespace, new ConcreteClientInsertOneModel(document));
    }

    public static ClientNamespacedUpdateOneModel updateOne(MongoNamespace namespace, Bson filter, Bson update) {
        Assertions.notNull("namespace", namespace);
        Assertions.notNull("filter", filter);
        Assertions.notNull("update", update);
        return new ConcreteClientNamespacedUpdateOneModel(namespace, new ConcreteClientUpdateOneModel(filter, update, null, null));
    }

    public static ClientNamespacedUpdateOneModel updateOne(MongoNamespace namespace, Bson filter, Bson update, ClientUpdateOneOptions options) {
        Assertions.notNull("namespace", namespace);
        Assertions.notNull("filter", filter);
        Assertions.notNull("update", update);
        Assertions.notNull("options", options);
        return new ConcreteClientNamespacedUpdateOneModel(namespace, new ConcreteClientUpdateOneModel(filter, update, null, options));
    }

    public static ClientNamespacedUpdateOneModel updateOne(MongoNamespace namespace, Bson filter, Iterable<? extends Bson> updatePipeline) {
        Assertions.notNull("namespace", namespace);
        Assertions.notNull("filter", filter);
        Assertions.notNull("updatePipeline", updatePipeline);
        return new ConcreteClientNamespacedUpdateOneModel(namespace, new ConcreteClientUpdateOneModel(filter, null, updatePipeline, null));
    }

    public static ClientNamespacedUpdateOneModel updateOne(MongoNamespace namespace, Bson filter, Iterable<? extends Bson> updatePipeline, ClientUpdateOneOptions options) {
        Assertions.notNull("namespace", namespace);
        Assertions.notNull("filter", filter);
        Assertions.notNull("updatePipeline", updatePipeline);
        Assertions.notNull("options", options);
        return new ConcreteClientNamespacedUpdateOneModel(namespace, new ConcreteClientUpdateOneModel(filter, null, updatePipeline, options));
    }

    public static ClientNamespacedUpdateManyModel updateMany(MongoNamespace namespace, Bson filter, Bson update) {
        Assertions.notNull("namespace", namespace);
        Assertions.notNull("filter", filter);
        Assertions.notNull("update", update);
        return new ConcreteClientNamespacedUpdateManyModel(namespace, new ConcreteClientUpdateManyModel(filter, update, null, null));
    }

    public static ClientNamespacedUpdateManyModel updateMany(MongoNamespace namespace, Bson filter, Bson update, ClientUpdateManyOptions options) {
        Assertions.notNull("namespace", namespace);
        Assertions.notNull("filter", filter);
        Assertions.notNull("update", update);
        Assertions.notNull("options", options);
        return new ConcreteClientNamespacedUpdateManyModel(namespace, new ConcreteClientUpdateManyModel(filter, update, null, options));
    }

    public static ClientNamespacedUpdateManyModel updateMany(MongoNamespace namespace, Bson filter, Iterable<? extends Bson> updatePipeline) {
        Assertions.notNull("namespace", namespace);
        Assertions.notNull("filter", filter);
        Assertions.notNull("updatePipeline", updatePipeline);
        return new ConcreteClientNamespacedUpdateManyModel(namespace, new ConcreteClientUpdateManyModel(filter, null, updatePipeline, null));
    }

    public static ClientNamespacedUpdateManyModel updateMany(MongoNamespace namespace, Bson filter, Iterable<? extends Bson> updatePipeline, ClientUpdateManyOptions options) {
        Assertions.notNull("namespace", namespace);
        Assertions.notNull("filter", filter);
        Assertions.notNull("updatePipeline", updatePipeline);
        Assertions.notNull("options", options);
        return new ConcreteClientNamespacedUpdateManyModel(namespace, new ConcreteClientUpdateManyModel(filter, null, updatePipeline, options));
    }

    public static <TDocument> ClientNamespacedReplaceOneModel replaceOne(MongoNamespace namespace, Bson filter, TDocument replacement) {
        Assertions.notNull("namespace", namespace);
        Assertions.notNull("filter", filter);
        Assertions.notNull("replacement", replacement);
        return new ConcreteClientNamespacedReplaceOneModel(namespace, new ConcreteClientReplaceOneModel(filter, replacement, null));
    }

    public static <TDocument> ClientNamespacedReplaceOneModel replaceOne(MongoNamespace namespace, Bson filter, TDocument replacement, ClientReplaceOneOptions options) {
        Assertions.notNull("namespace", namespace);
        Assertions.notNull("filter", filter);
        Assertions.notNull("replacement", replacement);
        Assertions.notNull("options", options);
        return new ConcreteClientNamespacedReplaceOneModel(namespace, new ConcreteClientReplaceOneModel(filter, replacement, options));
    }

    public static ClientNamespacedDeleteOneModel deleteOne(MongoNamespace namespace, Bson filter) {
        Assertions.notNull("namespace", namespace);
        Assertions.notNull("filter", filter);
        return new ConcreteClientNamespacedDeleteOneModel(namespace, new ConcreteClientDeleteOneModel(filter, null));
    }

    public static ClientNamespacedDeleteOneModel deleteOne(MongoNamespace namespace, Bson filter, ClientDeleteOneOptions options) {
        Assertions.notNull("namespace", namespace);
        Assertions.notNull("filter", filter);
        Assertions.notNull("options", options);
        return new ConcreteClientNamespacedDeleteOneModel(namespace, new ConcreteClientDeleteOneModel(filter, options));
    }

    public static ClientNamespacedDeleteManyModel deleteMany(MongoNamespace namespace, Bson filter) {
        Assertions.notNull("namespace", namespace);
        Assertions.notNull("filter", filter);
        return new ConcreteClientNamespacedDeleteManyModel(namespace, new ConcreteClientDeleteManyModel(filter, null));
    }

    public static ClientNamespacedDeleteManyModel deleteMany(MongoNamespace namespace, Bson filter, ClientDeleteManyOptions options) {
        Assertions.notNull("namespace", namespace);
        Assertions.notNull("filter", filter);
        Assertions.notNull("options", options);
        return new ConcreteClientNamespacedDeleteManyModel(namespace, new ConcreteClientDeleteManyModel(filter, options));
    }
}

