/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.mortbay.component.LifeCycle;
import org.mortbay.io.Buffer;
import org.mortbay.io.ByteArrayBuffer;
import org.mortbay.io.nio.DirectNIOBuffer;
import org.mortbay.io.nio.IndirectNIOBuffer;
import org.mortbay.jetty.AbstractBuffers;
import org.mortbay.jetty.HttpSchemes;
import org.mortbay.jetty.client.Address;
import org.mortbay.jetty.client.HttpDestination;
import org.mortbay.jetty.client.HttpExchange;
import org.mortbay.jetty.client.SelectConnector;
import org.mortbay.jetty.client.SocketConnector;
import org.mortbay.jetty.client.security.Authorization;
import org.mortbay.jetty.client.security.RealmResolver;
import org.mortbay.log.Log;
import org.mortbay.resource.Resource;
import org.mortbay.thread.QueuedThreadPool;
import org.mortbay.thread.ThreadPool;
import org.mortbay.thread.Timeout;
import org.mortbay.util.Attributes;
import org.mortbay.util.AttributesMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpClient
extends AbstractBuffers
implements Attributes {
    public static final int CONNECTOR_SOCKET = 0;
    public static final int CONNECTOR_SELECT_CHANNEL = 2;
    private int _connectorType = 2;
    private boolean _useDirectBuffers = true;
    private int _maxConnectionsPerAddress = 32;
    private Map<Address, HttpDestination> _destinations = new HashMap<Address, HttpDestination>();
    ThreadPool _threadPool;
    Connector _connector;
    private long _idleTimeout = 20000L;
    private long _timeout = 320000L;
    private int _soTimeout = 10000;
    private Timeout _timeoutQ = new Timeout();
    private Timeout _idleTimeoutQ = new Timeout();
    private Address _proxy;
    private Authorization _proxyAuthentication;
    private Set<String> _noProxy;
    private int _maxRetries = 3;
    private LinkedList<String> _registeredListeners;
    private String _keyStoreLocation;
    private String _keyStoreType = "JKS";
    private String _keyStorePassword;
    private String _keyManagerAlgorithm = "SunX509";
    private String _keyManagerPassword;
    private String _trustStoreLocation;
    private String _trustStoreType = "JKS";
    private String _trustStorePassword;
    private String _trustManagerAlgorithm = "SunX509";
    private SSLContext _sslContext;
    private String _protocol = "TLS";
    private String _provider;
    private String _secureRandomAlgorithm;
    private RealmResolver _realmResolver;
    private AttributesMap _attributes = new AttributesMap();

    public void dump() throws IOException {
        for (Map.Entry<Address, HttpDestination> entry : this._destinations.entrySet()) {
            System.err.println("\n" + entry.getKey() + ":");
            entry.getValue().dump();
        }
    }

    public void send(HttpExchange exchange) throws IOException {
        if (!this.isStarted()) {
            throw new IllegalStateException("!started");
        }
        boolean ssl = HttpSchemes.HTTPS_BUFFER.equalsIgnoreCase(exchange.getScheme());
        exchange.setStatus(1);
        HttpDestination destination = this.getDestination(exchange.getAddress(), ssl);
        destination.send(exchange);
    }

    public ThreadPool getThreadPool() {
        return this._threadPool;
    }

    public void setThreadPool(ThreadPool threadPool) {
        this._threadPool = threadPool;
    }

    public Object getAttribute(String name) {
        return this._attributes.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return this._attributes.getAttributeNames();
    }

    public void removeAttribute(String name) {
        this._attributes.removeAttribute(name);
    }

    public void setAttribute(String name, Object attribute) {
        this._attributes.setAttribute(name, attribute);
    }

    public void clearAttributes() {
        this._attributes.clearAttributes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpDestination getDestination(Address remote, boolean ssl) throws UnknownHostException, IOException {
        if (remote == null) {
            throw new UnknownHostException("Remote socket address cannot be null.");
        }
        Map<Address, HttpDestination> map = this._destinations;
        synchronized (map) {
            HttpDestination destination = this._destinations.get(remote);
            if (destination == null) {
                destination = new HttpDestination(this, remote, ssl, this._maxConnectionsPerAddress);
                if (!(this._proxy == null || this._noProxy != null && this._noProxy.contains(remote.getHost()))) {
                    destination.setProxy(this._proxy);
                    if (this._proxyAuthentication != null) {
                        destination.setProxyAuthentication(this._proxyAuthentication);
                    }
                }
                this._destinations.put(remote, destination);
            }
            return destination;
        }
    }

    public void schedule(Timeout.Task task) {
        this._timeoutQ.schedule(task);
    }

    public void scheduleIdle(Timeout.Task task) {
        this._idleTimeoutQ.schedule(task);
    }

    public void cancel(Timeout.Task task) {
        task.cancel();
    }

    public boolean getUseDirectBuffers() {
        return this._useDirectBuffers;
    }

    public void setRealmResolver(RealmResolver resolver) {
        this._realmResolver = resolver;
    }

    public RealmResolver getRealmResolver() {
        return this._realmResolver;
    }

    public boolean hasRealms() {
        return this._realmResolver != null;
    }

    public void registerListener(String listenerClass) {
        if (this._registeredListeners == null) {
            this._registeredListeners = new LinkedList();
        }
        this._registeredListeners.add(listenerClass);
    }

    public LinkedList<String> getRegisteredListeners() {
        return this._registeredListeners;
    }

    public void setUseDirectBuffers(boolean direct) {
        this._useDirectBuffers = direct;
    }

    public int getConnectorType() {
        return this._connectorType;
    }

    public void setConnectorType(int connectorType) {
        this._connectorType = connectorType;
    }

    protected Buffer newBuffer(int size) {
        if (this._connectorType != 0) {
            Object buf = null;
            buf = size == this.getHeaderBufferSize() ? new IndirectNIOBuffer(size) : (this._useDirectBuffers ? new DirectNIOBuffer(size) : new IndirectNIOBuffer(size));
            return buf;
        }
        return new ByteArrayBuffer(size);
    }

    public int getMaxConnectionsPerAddress() {
        return this._maxConnectionsPerAddress;
    }

    public void setMaxConnectionsPerAddress(int maxConnectionsPerAddress) {
        this._maxConnectionsPerAddress = maxConnectionsPerAddress;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this._timeoutQ.setDuration(this._timeout);
        this._timeoutQ.setNow();
        this._idleTimeoutQ.setDuration(this._idleTimeout);
        this._idleTimeoutQ.setNow();
        if (this._threadPool == null) {
            QueuedThreadPool pool = new QueuedThreadPool();
            pool.setMaxThreads(16);
            pool.setDaemon(true);
            pool.setName("HttpClient");
            this._threadPool = pool;
        }
        if (this._threadPool instanceof LifeCycle) {
            ((LifeCycle)this._threadPool).start();
        }
        this._connector = this._connectorType == 2 ? new SelectConnector(this) : new SocketConnector(this);
        this._connector.start();
        this._threadPool.dispatch(new Runnable(){

            public void run() {
                while (HttpClient.this.isRunning()) {
                    HttpClient.this._timeoutQ.tick(System.currentTimeMillis());
                    HttpClient.this._idleTimeoutQ.tick(HttpClient.this._timeoutQ.getNow());
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        Log.ignore((Throwable)e);
                    }
                }
            }
        });
    }

    long getNow() {
        return this._timeoutQ.getNow();
    }

    protected void doStop() throws Exception {
        this._connector.stop();
        this._connector = null;
        if (this._threadPool instanceof LifeCycle) {
            ((LifeCycle)this._threadPool).stop();
        }
        for (HttpDestination destination : this._destinations.values()) {
            destination.close();
        }
        this._timeoutQ.cancelAll();
        this._idleTimeoutQ.cancelAll();
        super.doStop();
    }

    protected SSLContext getSSLContext() throws IOException {
        if (this._sslContext == null) {
            this._sslContext = this._keyStoreLocation == null ? this.getLooseSSLContext() : this.getStrictSSLContext();
        }
        return this._sslContext;
    }

    protected SSLContext getStrictSSLContext() throws IOException {
        try {
            if (this._trustStoreLocation == null) {
                this._trustStoreLocation = this._keyStoreLocation;
                this._trustStoreType = this._keyStoreType;
            }
            KeyManager[] keyManagers = null;
            InputStream keystoreInputStream = null;
            keystoreInputStream = Resource.newResource((String)this._keyStoreLocation).getInputStream();
            KeyStore keyStore = KeyStore.getInstance(this._keyStoreType);
            keyStore.load(keystoreInputStream, this._keyStorePassword == null ? null : this._keyStorePassword.toString().toCharArray());
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(this._keyManagerAlgorithm);
            keyManagerFactory.init(keyStore, this._keyManagerPassword == null ? null : this._keyManagerPassword.toString().toCharArray());
            keyManagers = keyManagerFactory.getKeyManagers();
            TrustManager[] trustManagers = null;
            InputStream truststoreInputStream = null;
            truststoreInputStream = Resource.newResource((String)this._trustStoreLocation).getInputStream();
            KeyStore trustStore = KeyStore.getInstance(this._trustStoreType);
            trustStore.load(truststoreInputStream, this._trustStorePassword == null ? null : this._trustStorePassword.toString().toCharArray());
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(this._trustManagerAlgorithm);
            trustManagerFactory.init(trustStore);
            trustManagers = trustManagerFactory.getTrustManagers();
            SecureRandom secureRandom = this._secureRandomAlgorithm == null ? null : SecureRandom.getInstance(this._secureRandomAlgorithm);
            SSLContext context = this._provider == null ? SSLContext.getInstance(this._protocol) : SSLContext.getInstance(this._protocol, this._provider);
            context.init(keyManagers, trustManagers, secureRandom);
            return context;
        }
        catch (Exception e) {
            Log.debug((Throwable)e);
            throw new IOException("error generating ssl context for " + this._keyStoreLocation + " " + e.getMessage());
        }
    }

    protected SSLContext getLooseSSLContext() throws IOException {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        HostnameVerifier hostnameVerifier = new HostnameVerifier(){

            public boolean verify(String urlHostName, SSLSession session) {
                Log.warn((String)("Warning: URL Host: " + urlHostName + " vs." + session.getPeerHost()));
                return true;
            }
        };
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            return sslContext;
        }
        catch (Exception e) {
            Log.debug((Throwable)e);
            throw new IOException("issue ignoring certs");
        }
    }

    public long getIdleTimeout() {
        return this._idleTimeout;
    }

    public void setIdleTimeout(long ms) {
        this._idleTimeout = ms;
    }

    public int getSoTimeout() {
        return this._soTimeout;
    }

    public void setSoTimeout(int so) {
        this._soTimeout = so;
    }

    public long getTimeout() {
        return this._timeout;
    }

    public void setTimeout(long ms) {
        this._timeout = ms;
    }

    public Address getProxy() {
        return this._proxy;
    }

    public void setProxy(Address proxy) {
        this._proxy = proxy;
    }

    public Authorization getProxyAuthentication() {
        return this._proxyAuthentication;
    }

    public void setProxyAuthentication(Authorization authentication) {
        this._proxyAuthentication = authentication;
    }

    public boolean isProxied() {
        return this._proxy != null;
    }

    public Set<String> getNoProxy() {
        return this._noProxy;
    }

    public void setNoProxy(Set<String> noProxyAddresses) {
        this._noProxy = noProxyAddresses;
    }

    public int maxRetries() {
        return this._maxRetries;
    }

    public void setMaxRetries(int retries) {
        this._maxRetries = retries;
    }

    public String getTrustStoreLocation() {
        return this._trustStoreLocation;
    }

    public void setTrustStoreLocation(String trustStoreLocation) {
        this._trustStoreLocation = trustStoreLocation;
    }

    public String getKeyStoreLocation() {
        return this._keyStoreLocation;
    }

    public void setKeyStoreLocation(String keyStoreLocation) {
        this._keyStoreLocation = keyStoreLocation;
    }

    public void setKeyStorePassword(String _keyStorePassword) {
        this._keyStorePassword = _keyStorePassword;
    }

    public void setKeyManagerPassword(String _keyManagerPassword) {
        this._keyManagerPassword = _keyManagerPassword;
    }

    public void setTrustStorePassword(String _trustStorePassword) {
        this._trustStorePassword = _trustStorePassword;
    }

    static interface Connector
    extends LifeCycle {
        public void startConnection(HttpDestination var1) throws IOException;
    }
}

