/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import org.mortbay.log.Log;
import org.mortbay.resource.BadResource;
import org.mortbay.resource.Resource;
import org.mortbay.resource.URLResource;
import org.mortbay.util.URIUtil;

public class FileResource
extends URLResource {
    private static boolean __checkAliases = "true".equalsIgnoreCase(System.getProperty("org.mortbay.util.FileResource.checkAliases", "true"));
    private File _file;
    private transient URL _alias = null;
    private transient boolean _aliasChecked = false;

    public static void setCheckAliases(boolean checkAliases) {
        __checkAliases = checkAliases;
    }

    public static boolean getCheckAliases() {
        return __checkAliases;
    }

    public FileResource(URL url) throws IOException, URISyntaxException {
        super(url, null);
        try {
            this._file = new File(new URI(url.toString()));
        }
        catch (Exception e) {
            Log.ignore(e);
            try {
                String file_url = "file:" + URIUtil.encodePath(url.toString().substring(5));
                URI uri = new URI(file_url);
                this._file = uri.getAuthority() == null ? new File(uri) : new File("//" + uri.getAuthority() + URIUtil.decodePath(url.getFile()));
            }
            catch (Exception e2) {
                Log.ignore(e2);
                this.checkConnection();
                Permission perm = this._connection.getPermission();
                this._file = new File(perm == null ? url.getFile() : perm.getName());
            }
        }
        if (this._file.isDirectory()) {
            if (!this._urlString.endsWith("/")) {
                this._urlString = this._urlString + "/";
            }
        } else if (this._urlString.endsWith("/")) {
            this._urlString = this._urlString.substring(0, this._urlString.length() - 1);
        }
    }

    FileResource(URL url, URLConnection connection, File file) {
        super(url, connection);
        this._file = file;
        if (this._file.isDirectory() && !this._urlString.endsWith("/")) {
            this._urlString = this._urlString + "/";
        }
    }

    public Resource addPath(String path) throws IOException, MalformedURLException {
        URLResource r = null;
        String url = null;
        if ("/".equals(path = URIUtil.canonicalPath(path))) {
            return this;
        }
        if (!this.isDirectory()) {
            r = (FileResource)super.addPath(path);
            url = r._urlString;
        } else {
            if (path == null) {
                throw new MalformedURLException();
            }
            String rel = path;
            if (path.startsWith("/")) {
                rel = path.substring(1);
            }
            url = URIUtil.addPaths(this._urlString, URIUtil.encodePath(rel));
            r = (URLResource)Resource.newResource(url);
        }
        String encoded = URIUtil.encodePath(path);
        int expected = r.toString().length() - encoded.length();
        int index = r._urlString.lastIndexOf(encoded, expected);
        if (!(expected == index || expected - 1 == index && !path.endsWith("/") && r.isDirectory() || r instanceof BadResource)) {
            ((FileResource)r)._alias = new URL(url);
            ((FileResource)r)._aliasChecked = true;
        }
        return r;
    }

    public URL getAlias() {
        if (__checkAliases && !this._aliasChecked) {
            try {
                String abs = this._file.getAbsolutePath();
                String can = this._file.getCanonicalPath();
                if (abs.length() != can.length() || !abs.equals(can)) {
                    this._alias = new File(can).toURI().toURL();
                }
                this._aliasChecked = true;
                if (this._alias != null && Log.isDebugEnabled()) {
                    Log.debug("ALIAS abs=" + abs);
                    Log.debug("ALIAS can=" + can);
                }
            }
            catch (Exception e) {
                Log.warn("EXCEPTION ", e);
                return this.getURL();
            }
        }
        return this._alias;
    }

    public boolean exists() {
        return this._file.exists();
    }

    public long lastModified() {
        return this._file.lastModified();
    }

    public boolean isDirectory() {
        return this._file.isDirectory();
    }

    public long length() {
        return this._file.length();
    }

    public String getName() {
        return this._file.getAbsolutePath();
    }

    public File getFile() {
        return this._file;
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this._file);
    }

    public OutputStream getOutputStream() throws IOException, SecurityException {
        return new FileOutputStream(this._file);
    }

    public boolean delete() throws SecurityException {
        return this._file.delete();
    }

    public boolean renameTo(Resource dest) throws SecurityException {
        if (dest instanceof FileResource) {
            return this._file.renameTo(((FileResource)dest)._file);
        }
        return false;
    }

    public String[] list() {
        String[] list = this._file.list();
        if (list == null) {
            return null;
        }
        int i = list.length;
        while (i-- > 0) {
            if (!new File(this._file, list[i]).isDirectory() || list[i].endsWith("/")) continue;
            int n = i;
            list[n] = list[n] + "/";
        }
        return list;
    }

    public String encode(String uri) {
        return uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (null == o || !(o instanceof FileResource)) {
            return false;
        }
        FileResource f = (FileResource)o;
        return f._file == this._file || null != this._file && this._file.equals(f._file);
    }

    public int hashCode() {
        return null == this._file ? super.hashCode() : this._file.hashCode();
    }

    static {
        if (__checkAliases) {
            Log.debug("Checking Resource aliases");
        }
    }
}

